/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.spi;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.hql.internal.NamedHqlQueryMementoImpl;
import org.hibernate.query.hql.spi.SqmQueryImplementor;
import org.hibernate.query.named.AbstractNamedQueryMemento;
import org.hibernate.query.named.NamedQueryMemento;

public interface NamedHqlQueryMemento
extends NamedQueryMemento {
    public String getHqlString();

    public <T> SqmQueryImplementor<T> toQuery(SharedSessionContractImplementor var1, Class<T> var2);

    public <T> SqmQueryImplementor<T> toQuery(SharedSessionContractImplementor var1);

    public Integer getFirstResult();

    public Integer getMaxResults();

    public LockOptions getLockOptions();

    public Map<String, String> getParameterTypes();

    @Override
    public NamedHqlQueryMemento makeCopy(String var1);

    public static class Builder
    extends AbstractNamedQueryMemento.AbstractBuilder<Builder> {
        protected String hqlString;
        protected LockOptions lockOptions;
        protected Integer firstResult;
        protected Integer maxResults;
        protected Map<String, String> parameterTypes;

        public Builder(String name) {
            super(name);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public Builder addParameterType(String name, String typeName) {
            if (this.parameterTypes == null) {
                this.parameterTypes = new HashMap<String, String>();
            }
            this.parameterTypes.put(name, typeName);
            return this;
        }

        public Builder setParameterTypes(Map<String, String> parameterTypes) {
            this.parameterTypes = parameterTypes;
            return this;
        }

        public Builder setLockOptions(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        public Builder setFirstResult(Integer firstResult) {
            this.firstResult = firstResult;
            return this;
        }

        public Builder setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public NamedHqlQueryMemento createNamedQueryDefinition() {
            return new NamedHqlQueryMementoImpl(this.name, this.hqlString, this.firstResult, this.maxResults, this.cacheable, this.cacheRegion, this.cacheMode, this.flushMode, this.readOnly, this.lockOptions, this.timeout, this.fetchSize, this.comment, this.parameterTypes, this.hints);
        }
    }
}

