/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.Objects;
import org.hibernate.query.BindableType;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.AbstractQueryParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;

public class QueryParameterPositionalImpl<T>
extends AbstractQueryParameter<T> {
    private final int position;

    public static <T> QueryParameterPositionalImpl<T> fromSqm(SqmParameter<T> parameter) {
        assert (parameter.getPosition() != null);
        assert (parameter.getName() == null);
        return new QueryParameterPositionalImpl<T>(parameter.getPosition(), parameter.allowMultiValuedBinding(), parameter.getAnticipatedType());
    }

    public static <T> QueryParameterPositionalImpl<T> fromNativeQuery(int position) {
        return new QueryParameterPositionalImpl<T>(position, false, null);
    }

    public QueryParameterPositionalImpl(Integer position, boolean allowMultiValuedBinding, BindableType<T> anticipatedType) {
        super(allowMultiValuedBinding, anticipatedType);
        this.position = position;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public NamedQueryMemento.ParameterMemento toMemento() {
        return session -> new QueryParameterPositionalImpl(this.getPosition(), this.allowsMultiValuedBinding(), this.getHibernateType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryParameterPositionalImpl that = (QueryParameterPositionalImpl)o;
        return this.position == that.position;
    }

    public int hashCode() {
        return Objects.hash(this.position);
    }
}

