/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.Incubating;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.query.spi.NativeQueryInterpreter;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.query.criteria.ValueHandlingMode;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.hql.internal.StandardHqlTranslator;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.internal.QueryInterpretationCacheDisabledImpl;
import org.hibernate.query.internal.QueryInterpretationCacheStandardImpl;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.spi.QueryEngineOptions;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.internal.SqmCreationOptionsStandard;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

@Incubating
public class QueryEngine {
    public static final int DEFAULT_QUERY_PLAN_MAX_COUNT = 2048;
    @Deprecated
    public static final int DEFAULT_PARAMETER_METADATA_MAX_COUNT = 128;
    private static final Logger LOG_HQL_FUNCTIONS = CoreLogging.logger("org.hibernate.HQL_FUNCTIONS");
    private final NamedObjectRepository namedObjectRepository;
    private final SqmCriteriaNodeBuilder criteriaBuilder;
    private final HqlTranslator hqlTranslator;
    private final SqmTranslatorFactory sqmTranslatorFactory;
    private final NativeQueryInterpreter nativeQueryInterpreter;
    private final QueryInterpretationCache interpretationCache;
    private final SqmFunctionRegistry sqmFunctionRegistry;
    private final TypeConfiguration typeConfiguration;
    private final int preferredSqlTypeCodeForBoolean;

    public static QueryEngine from(SessionFactoryImplementor sessionFactory, MetadataImplementor metadata) {
        SqmFunctionRegistry customSqmFunctionRegistry;
        SessionFactoryOptions queryEngineOptions = sessionFactory.getSessionFactoryOptions();
        SqmCreationOptionsStandard sqmCreationOptions = new SqmCreationOptionsStandard(sessionFactory);
        Dialect dialect = sessionFactory.getJdbcServices().getDialect();
        HqlTranslator hqlTranslator = QueryEngine.resolveHqlTranslator(queryEngineOptions, dialect, sessionFactory, sqmCreationOptions);
        SqmTranslatorFactory sqmTranslatorFactory = QueryEngine.resolveSqmTranslatorFactory(queryEngineOptions, dialect);
        if (queryEngineOptions.getCustomSqmFunctionRegistry() == null) {
            Map<String, SqmFunctionDescriptor> customSqlFunctionMap = queryEngineOptions.getCustomSqlFunctionMap();
            if (customSqlFunctionMap == null || customSqlFunctionMap.isEmpty()) {
                customSqmFunctionRegistry = null;
            } else {
                customSqmFunctionRegistry = new SqmFunctionRegistry();
                customSqlFunctionMap.forEach(customSqmFunctionRegistry::register);
            }
        } else {
            customSqmFunctionRegistry = queryEngineOptions.getCustomSqmFunctionRegistry();
        }
        return new QueryEngine(sessionFactory.getUuid(), sessionFactory.getName(), sessionFactory.getSessionFactoryOptions().getJpaCompliance(), () -> sessionFactory.getRuntimeMetamodels().getJpaMetamodel(), sessionFactory.getSessionFactoryOptions().getCriteriaValueHandlingMode(), sessionFactory.getSessionFactoryOptions().getPreferredSqlTypeCodeForBoolean(), metadata.buildNamedQueryRepository(sessionFactory), hqlTranslator, sqmTranslatorFactory, sessionFactory.getServiceRegistry().getService(NativeQueryInterpreter.class), QueryEngine.buildInterpretationCache(sessionFactory::getStatistics, sessionFactory.getProperties()), metadata.getTypeConfiguration(), dialect, customSqmFunctionRegistry, sessionFactory.getServiceRegistry());
    }

    public QueryEngine(String uuid, String name, JpaCompliance jpaCompliance, Supplier<JpaMetamodelImplementor> jpaMetamodelAccess, ValueHandlingMode criteriaValueHandlingMode, int preferredSqlTypeCodeForBoolean, NamedObjectRepository namedObjectRepository, HqlTranslator hqlTranslator, SqmTranslatorFactory sqmTranslatorFactory, NativeQueryInterpreter nativeQueryInterpreter, QueryInterpretationCache interpretationCache, final TypeConfiguration typeConfiguration, Dialect dialect, SqmFunctionRegistry userDefinedRegistry, final ServiceRegistry serviceRegistry) {
        this.namedObjectRepository = namedObjectRepository;
        this.sqmTranslatorFactory = sqmTranslatorFactory;
        this.nativeQueryInterpreter = nativeQueryInterpreter;
        this.interpretationCache = interpretationCache;
        this.hqlTranslator = hqlTranslator;
        this.criteriaBuilder = new SqmCriteriaNodeBuilder(uuid, name, jpaCompliance.isJpaQueryComplianceEnabled(), this, jpaMetamodelAccess, serviceRegistry, criteriaValueHandlingMode);
        this.sqmFunctionRegistry = new SqmFunctionRegistry();
        this.typeConfiguration = typeConfiguration;
        this.preferredSqlTypeCodeForBoolean = preferredSqlTypeCodeForBoolean;
        dialect.initializeFunctionRegistry(this);
        if (userDefinedRegistry != null) {
            userDefinedRegistry.overlay(this.sqmFunctionRegistry);
        }
        FunctionContributions functionContributions = new FunctionContributions(){

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }

            @Override
            public SqmFunctionRegistry getFunctionRegistry() {
                return QueryEngine.this.sqmFunctionRegistry;
            }

            @Override
            public ServiceRegistry getServiceRegistry() {
                return serviceRegistry;
            }
        };
        for (FunctionContributor contributor : QueryEngine.sortedFunctionContributors(serviceRegistry)) {
            contributor.contributeFunctions(functionContributions);
        }
        if (LOG_HQL_FUNCTIONS.isDebugEnabled()) {
            this.sqmFunctionRegistry.getFunctionsByName().forEach(entry -> LOG_HQL_FUNCTIONS.debug(((SqmFunctionDescriptor)entry.getValue()).getSignature((String)entry.getKey())));
        }
    }

    public QueryEngine(String uuid, String name, final JpaMetamodelImplementor jpaMetamodel, ValueHandlingMode criteriaValueHandlingMode, int preferredSqlTypeCodeForBoolean, final boolean useStrictJpaCompliance, NamedObjectRepository namedObjectRepository, NativeQueryInterpreter nativeQueryInterpreter, Dialect dialect, final ServiceRegistry serviceRegistry) {
        this.namedObjectRepository = namedObjectRepository;
        this.sqmTranslatorFactory = null;
        this.nativeQueryInterpreter = nativeQueryInterpreter;
        this.sqmFunctionRegistry = new SqmFunctionRegistry();
        this.typeConfiguration = jpaMetamodel.getTypeConfiguration();
        this.preferredSqlTypeCodeForBoolean = preferredSqlTypeCodeForBoolean;
        dialect.initializeFunctionRegistry(this);
        this.criteriaBuilder = new SqmCriteriaNodeBuilder(uuid, name, false, this, () -> jpaMetamodel, serviceRegistry, criteriaValueHandlingMode);
        SqmCreationContext sqmCreationContext = new SqmCreationContext(){

            @Override
            public JpaMetamodelImplementor getJpaMetamodel() {
                return jpaMetamodel;
            }

            @Override
            public ServiceRegistry getServiceRegistry() {
                return serviceRegistry;
            }

            @Override
            public QueryEngine getQueryEngine() {
                return QueryEngine.this;
            }

            @Override
            public NodeBuilder getNodeBuilder() {
                return QueryEngine.this.criteriaBuilder;
            }
        };
        this.hqlTranslator = new StandardHqlTranslator(sqmCreationContext, new SqmCreationOptions(){

            @Override
            public boolean useStrictJpaCompliance() {
                return useStrictJpaCompliance;
            }
        });
        this.interpretationCache = QueryEngine.buildInterpretationCache(() -> serviceRegistry.getService(StatisticsImplementor.class), serviceRegistry.getService(ConfigurationService.class).getSettings());
    }

    private static HqlTranslator resolveHqlTranslator(QueryEngineOptions runtimeOptions, Dialect dialect, SqmCreationContext sqmCreationContext, SqmCreationOptions sqmCreationOptions) {
        if (runtimeOptions.getCustomHqlTranslator() != null) {
            return runtimeOptions.getCustomHqlTranslator();
        }
        if (dialect.getHqlTranslator() != null) {
            return dialect.getHqlTranslator();
        }
        return new StandardHqlTranslator(sqmCreationContext, sqmCreationOptions);
    }

    private static SqmTranslatorFactory resolveSqmTranslatorFactory(QueryEngineOptions runtimeOptions, Dialect dialect) {
        if (runtimeOptions.getCustomSqmTranslatorFactory() != null) {
            return runtimeOptions.getCustomSqmTranslatorFactory();
        }
        if (dialect.getSqmTranslatorFactory() != null) {
            return dialect.getSqmTranslatorFactory();
        }
        return new StandardSqmTranslatorFactory();
    }

    private static List<FunctionContributor> sortedFunctionContributors(ServiceRegistry serviceRegistry) {
        ArrayList<FunctionContributor> contributors = new ArrayList<FunctionContributor>(serviceRegistry.getService(ClassLoaderService.class).loadJavaServices(FunctionContributor.class));
        contributors.sort(Comparator.comparingInt(FunctionContributor::ordinal).thenComparing(a -> a.getClass().getCanonicalName()));
        return contributors;
    }

    private static QueryInterpretationCache buildInterpretationCache(Supplier<StatisticsImplementor> statisticsSupplier, Map properties) {
        boolean explicitUseCache = ConfigurationHelper.getBoolean("hibernate.query.plan_cache_enabled", properties, true);
        Integer explicitMaxPlanSize = ConfigurationHelper.getInteger("hibernate.query.plan_cache_max_size", properties);
        if (explicitUseCache || explicitMaxPlanSize != null && explicitMaxPlanSize > 0) {
            int size = explicitMaxPlanSize != null ? explicitMaxPlanSize : 2048;
            return new QueryInterpretationCacheStandardImpl(size, statisticsSupplier);
        }
        return new QueryInterpretationCacheDisabledImpl(statisticsSupplier);
    }

    public void prepare(SessionFactoryImplementor sessionFactory, MetadataImplementor bootMetamodel, BootstrapContext bootstrapContext) {
        this.namedObjectRepository.prepare(sessionFactory, bootMetamodel, bootstrapContext);
    }

    public NamedObjectRepository getNamedObjectRepository() {
        return this.namedObjectRepository;
    }

    public SqmCriteriaNodeBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public HqlTranslator getHqlTranslator() {
        return this.hqlTranslator;
    }

    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return this.sqmTranslatorFactory;
    }

    public NativeQueryInterpreter getNativeQueryInterpreter() {
        return this.nativeQueryInterpreter;
    }

    public QueryInterpretationCache getInterpretationCache() {
        return this.interpretationCache;
    }

    public SqmFunctionRegistry getSqmFunctionRegistry() {
        return this.sqmFunctionRegistry;
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public void close() {
        if (this.namedObjectRepository != null) {
            this.namedObjectRepository.close();
        }
        if (this.criteriaBuilder != null) {
            this.criteriaBuilder.close();
        }
        if (this.hqlTranslator != null) {
            this.hqlTranslator.close();
        }
        if (this.interpretationCache != null) {
            this.interpretationCache.close();
        }
        if (this.sqmFunctionRegistry != null) {
            this.sqmFunctionRegistry.close();
        }
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return this.preferredSqlTypeCodeForBoolean;
    }
}

