/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.spi.TypeConfiguration;

public class SelfRenderingSqmFunction<T>
extends SqmFunction<T> {
    private final ReturnableType<T> impliedResultType;
    private final ArgumentsValidator argumentsValidator;
    private final FunctionReturnTypeResolver returnTypeResolver;
    private final FunctionRenderingSupport renderingSupport;
    private ReturnableType<?> resultType;

    public SelfRenderingSqmFunction(SqmFunctionDescriptor descriptor, FunctionRenderingSupport renderingSupport, List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(name, descriptor, impliedResultType, arguments, nodeBuilder);
        this.renderingSupport = renderingSupport;
        this.impliedResultType = impliedResultType;
        this.argumentsValidator = argumentsValidator;
        this.returnTypeResolver = returnTypeResolver;
    }

    public FunctionRenderingSupport getRenderingSupport() {
        return this.renderingSupport;
    }

    protected ArgumentsValidator getArgumentsValidator() {
        return this.argumentsValidator;
    }

    protected static List<SqlAstNode> resolveSqlAstArguments(List<? extends SqmTypedNode<?>> sqmArguments, SqmToSqlAstConverter walker) {
        if (sqmArguments == null || sqmArguments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SqlAstNode> sqlAstArguments = new ArrayList<SqlAstNode>(sqmArguments.size());
        for (SqmTypedNode<?> sqmArgument : sqmArguments) {
            sqlAstArguments.add((SqlAstNode)((SqmVisitableNode)((Object)sqmArgument)).accept(walker));
        }
        return sqlAstArguments;
    }

    @Override
    public SelfRenderingFunctionSqlAstExpression convertToSqlAst(SqmToSqlAstConverter walker) {
        ReturnableType<?> resultType = this.resolveResultType(walker.getCreationContext().getMappingMetamodel().getTypeConfiguration());
        List<SqlAstNode> arguments = SelfRenderingSqmFunction.resolveSqlAstArguments(this.getArguments(), walker);
        if (this.argumentsValidator != null) {
            this.argumentsValidator.validateSqlTypes(arguments, this.getFunctionName());
        }
        return new SelfRenderingFunctionSqlAstExpression(this.getFunctionName(), this.getRenderingSupport(), arguments, resultType, resultType == null ? null : this.getMappingModelExpressible(walker, resultType));
    }

    @Override
    public SqmExpressible<T> getNodeType() {
        SqmExpressible nodeType = super.getNodeType();
        if (nodeType == null) {
            nodeType = this.resolveResultType(this.nodeBuilder().getTypeConfiguration());
        }
        return nodeType;
    }

    protected ReturnableType<?> resolveResultType(TypeConfiguration typeConfiguration) {
        if (this.resultType == null) {
            this.resultType = this.returnTypeResolver.resolveFunctionReturnType(this.impliedResultType, this.getArguments(), typeConfiguration);
            this.setExpressibleType(this.resultType);
        }
        return this.resultType;
    }

    protected MappingModelExpressible<?> getMappingModelExpressible(SqmToSqlAstConverter walker, ReturnableType<?> resultType) {
        MappingModelExpressible mapping = resultType instanceof MappingModelExpressible ? (MappingModelExpressible)((Object)resultType) : this.returnTypeResolver.resolveFunctionReturnType(() -> {
            try {
                MappingMetamodelImplementor domainModel = walker.getCreationContext().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel();
                return (BasicValuedMapping)domainModel.resolveMappingExpressible(this.getNodeType(), walker.getFromClauseAccess()::getTableGroup);
            }
            catch (Exception e) {
                return null;
            }
        }, SelfRenderingSqmFunction.resolveSqlAstArguments(this.getArguments(), walker));
        return mapping;
    }
}

