/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.dialect.temptable.TemporaryTableHelper;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcInsert;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public final class ExecuteWithTemporaryTableHelper {
    private ExecuteWithTemporaryTableHelper() {
    }

    public static int saveMatchingIdsIntoIdTable(MultiTableSqmMutationConverter sqmConverter, Predicate suppliedPredicate, TemporaryTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
        assert (mutatingTableGroup.getModelPart() instanceof EntityMappingType);
        EntityMappingType mutatingEntityDescriptor = (EntityMappingType)mutatingTableGroup.getModelPart();
        NamedTableReference idTableReference = new NamedTableReference(idTable.getTableExpression(), "to_insert_", false, factory);
        InsertStatement idTableInsert = new InsertStatement(idTableReference);
        for (int i = 0; i < idTable.getColumns().size(); ++i) {
            TemporaryTableColumn column = idTable.getColumns().get(i);
            idTableInsert.addTargetColumnReferences(new ColumnReference(idTableReference, column.getColumnName(), false, null, null, column.getJdbcMapping(), factory));
        }
        QuerySpec matchingIdSelection = new QuerySpec(true, 1);
        idTableInsert.setSourceSelectStatement(matchingIdSelection);
        matchingIdSelection.getFromClause().addRoot(mutatingTableGroup);
        mutatingEntityDescriptor.getIdentifierMapping().forEachSelectable((jdbcPosition, selection) -> {
            TableReference tableReference = mutatingTableGroup.resolveTableReference(mutatingTableGroup.getNavigablePath(), selection.getContainingTableExpression());
            matchingIdSelection.getSelectClause().addSqlSelection(new SqlSelectionImpl(jdbcPosition, jdbcPosition + 1, sqmConverter.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(tableReference, selection, factory))));
        });
        if (idTable.getSessionUidColumn() != null) {
            int jdbcPosition2 = matchingIdSelection.getSelectClause().getSqlSelections().size();
            matchingIdSelection.getSelectClause().addSqlSelection(new SqlSelectionImpl(jdbcPosition2, jdbcPosition2 + 1, new QueryLiteral<String>(sessionUidAccess.apply(executionContext.getSession()), (BasicValuedMapping)((Object)idTable.getSessionUidColumn().getJdbcMapping()))));
        }
        matchingIdSelection.applyPredicate(suppliedPredicate);
        return ExecuteWithTemporaryTableHelper.saveIntoTemporaryTable(idTableInsert, jdbcParameterBindings, executionContext);
    }

    public static int saveIntoTemporaryTable(InsertStatement temporaryTableInsert, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        LockOptions lockOptions = executionContext.getQueryOptions().getLockOptions();
        LockMode lockMode = lockOptions.getLockMode();
        lockOptions.setLockMode(LockMode.WRITE);
        if (temporaryTableInsert.getSourceSelectStatement() != null && !jdbcEnvironment.getDialect().supportsOuterJoinForUpdate()) {
            temporaryTableInsert.getSourceSelectStatement().visitQuerySpecs(querySpec -> querySpec.getFromClause().visitTableJoins(tableJoin -> {
                if (tableJoin.getJoinType() != SqlAstJoinType.INNER) {
                    lockOptions.setLockMode(lockMode);
                }
            }));
        }
        JdbcInsert jdbcInsert = sqlAstTranslatorFactory.buildInsertTranslator(factory, temporaryTableInsert).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        lockOptions.setLockMode(lockMode);
        return jdbcServices.getJdbcMutationExecutor().execute(jdbcInsert, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }

    public static QuerySpec createIdTableSelectQuerySpec(TemporaryTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, EntityMappingType entityDescriptor, ExecutionContext executionContext) {
        return ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(idTable, null, sessionUidAccess, entityDescriptor, executionContext);
    }

    public static QuerySpec createIdTableSelectQuerySpec(TemporaryTable idTable, ModelPart fkModelPart, Function<SharedSessionContractImplementor, String> sessionUidAccess, EntityMappingType entityDescriptor, ExecutionContext executionContext) {
        QuerySpec querySpec = new QuerySpec(false);
        NamedTableReference idTableReference = new NamedTableReference(idTable.getTableExpression(), "temptable_", true, executionContext.getSession().getFactory());
        StandardTableGroup idTableGroup = new StandardTableGroup(true, new NavigablePath(idTableReference.getTableExpression()), entityDescriptor, null, idTableReference, null, executionContext.getSession().getFactory());
        querySpec.getFromClause().addRoot(idTableGroup);
        ExecuteWithTemporaryTableHelper.applyIdTableSelections(querySpec, idTableReference, idTable, fkModelPart, executionContext);
        ExecuteWithTemporaryTableHelper.applyIdTableRestrictions(querySpec, idTableReference, idTable, sessionUidAccess, executionContext);
        return querySpec;
    }

    private static void applyIdTableSelections(QuerySpec querySpec, TableReference tableReference, TemporaryTable idTable, ModelPart fkModelPart, ExecutionContext executionContext) {
        if (fkModelPart == null) {
            int size = idTable.getEntityDescriptor().getIdentifierMapping().getJdbcTypeCount();
            for (int i2 = 0; i2 < size; ++i2) {
                TemporaryTableColumn temporaryTableColumn = idTable.getColumns().get(i2);
                if (temporaryTableColumn == idTable.getSessionUidColumn()) continue;
                querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(i2 + 1, i2, new ColumnReference(tableReference, temporaryTableColumn.getColumnName(), false, null, null, temporaryTableColumn.getJdbcMapping(), executionContext.getSession().getFactory())));
            }
        } else {
            fkModelPart.forEachSelectable((i, selectableMapping) -> querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(i + 1, i, new ColumnReference(tableReference, selectableMapping.getSelectionExpression(), false, null, null, selectableMapping.getJdbcMapping(), executionContext.getSession().getFactory()))));
        }
    }

    private static void applyIdTableRestrictions(QuerySpec querySpec, TableReference idTableReference, TemporaryTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, ExecutionContext executionContext) {
        if (idTable.getSessionUidColumn() != null) {
            querySpec.applyPredicate(new ComparisonPredicate(new ColumnReference(idTableReference, idTable.getSessionUidColumn().getColumnName(), false, null, null, idTable.getSessionUidColumn().getJdbcMapping(), executionContext.getSession().getFactory()), ComparisonOperator.EQUAL, new QueryLiteral<String>(sessionUidAccess.apply(executionContext.getSession()), (BasicValuedMapping)((Object)idTable.getSessionUidColumn().getJdbcMapping()))));
        }
    }

    public static void performBeforeTemporaryTableUseActions(TemporaryTable temporaryTable, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        if (dialect.getTemporaryTableBeforeUseAction() == BeforeUseAction.CREATE) {
            TemporaryTableHelper.TemporaryTableCreationWork temporaryTableCreationWork = new TemporaryTableHelper.TemporaryTableCreationWork(temporaryTable, factory);
            TempTableDdlTransactionHandling ddlTransactionHandling = dialect.getTemporaryTableDdlTransactionHandling();
            if (ddlTransactionHandling == TempTableDdlTransactionHandling.NONE) {
                executionContext.getSession().doWork(temporaryTableCreationWork);
            } else {
                IsolationDelegate isolationDelegate = executionContext.getSession().getJdbcCoordinator().getJdbcSessionOwner().getTransactionCoordinator().createIsolationDelegate();
                isolationDelegate.delegateWork(temporaryTableCreationWork, ddlTransactionHandling == TempTableDdlTransactionHandling.ISOLATE_AND_TRANSACT);
            }
        }
    }

    public static void performAfterTemporaryTableUseActions(TemporaryTable temporaryTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, AfterUseAction afterUseAction, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        switch (afterUseAction) {
            case CLEAN: {
                TemporaryTableHelper.cleanTemporaryTableRows(temporaryTable, dialect.getTemporaryTableExporter(), sessionUidAccess, executionContext.getSession());
                break;
            }
            case DROP: {
                TemporaryTableHelper.TemporaryTableDropWork temporaryTableDropWork = new TemporaryTableHelper.TemporaryTableDropWork(temporaryTable, factory);
                TempTableDdlTransactionHandling ddlTransactionHandling = dialect.getTemporaryTableDdlTransactionHandling();
                if (ddlTransactionHandling == TempTableDdlTransactionHandling.NONE) {
                    executionContext.getSession().doWork(temporaryTableDropWork);
                    break;
                }
                IsolationDelegate isolationDelegate = executionContext.getSession().getJdbcCoordinator().getJdbcSessionOwner().getTransactionCoordinator().createIsolationDelegate();
                isolationDelegate.delegateWork(temporaryTableDropWork, ddlTransactionHandling == TempTableDdlTransactionHandling.ISOLATE_AND_TRANSACT);
            }
        }
    }
}

