/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableHelper;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.jboss.logging.Logger;

public abstract class PersistentTableStrategy {
    private static final Logger log = Logger.getLogger(PersistentTableStrategy.class);
    public static final String SHORT_NAME = "persistent";
    public static final String DROP_ID_TABLES = "hibernate.hql.bulk_id_strategy.persistent.drop_tables";
    public static final String SCHEMA = "hibernate.hql.bulk_id_strategy.persistent.schema";
    public static final String CATALOG = "hibernate.hql.bulk_id_strategy.persistent.catalog";
    private final TemporaryTable temporaryTable;
    private final SessionFactoryImplementor sessionFactory;
    private boolean prepared;
    private boolean created;
    private boolean released;

    public PersistentTableStrategy(TemporaryTable temporaryTable, SessionFactoryImplementor sessionFactory) {
        this.temporaryTable = temporaryTable;
        this.sessionFactory = sessionFactory;
        if (sessionFactory.getJdbcServices().getDialect().getTemporaryTableAfterUseAction() == AfterUseAction.DROP) {
            throw new IllegalArgumentException("Persistent ID tables cannot use AfterUseAction.DROP : " + temporaryTable.getTableExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(MappingModelCreationProcess mappingModelCreationProcess, JdbcConnectionAccess connectionAccess) {
        Connection connection;
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        log.debugf("Creating persistent ID table : %s", (Object)this.getTemporaryTable().getTableExpression());
        TemporaryTableHelper.TemporaryTableCreationWork temporaryTableCreationWork = new TemporaryTableHelper.TemporaryTableCreationWork(this.getTemporaryTable(), this.sessionFactory);
        try {
            connection = connectionAccess.obtainConnection();
        }
        catch (UnsupportedOperationException e) {
            log.debug("Unable to obtain JDBC connection; assuming ID tables already exist or wont be needed");
            return;
        }
        catch (SQLException e) {
            log.error((Object)"Unable obtain JDBC Connection", e);
            return;
        }
        try {
            temporaryTableCreationWork.execute(connection);
            this.created = true;
        }
        finally {
            try {
                connectionAccess.releaseConnection(connection);
            }
            catch (SQLException sQLException) {}
        }
        if (this.created) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(SessionFactoryImplementor sessionFactory, JdbcConnectionAccess connectionAccess) {
        Connection connection;
        if (this.released) {
            return;
        }
        this.released = true;
        if (this.created) {
            return;
        }
        TemporaryTable temporaryTable = this.getTemporaryTable();
        log.debugf("Dropping persistent ID table : %s", (Object)temporaryTable.getTableExpression());
        TemporaryTableHelper.TemporaryTableDropWork temporaryTableDropWork = new TemporaryTableHelper.TemporaryTableDropWork(temporaryTable, sessionFactory);
        try {
            connection = connectionAccess.obtainConnection();
        }
        catch (UnsupportedOperationException e) {
            log.debugf("Unable to obtain JDBC connection; unable to drop persistent ID table : %s", (Object)temporaryTable.getTableExpression());
            return;
        }
        catch (SQLException e) {
            log.error((Object)"Unable obtain JDBC Connection", e);
            return;
        }
        try {
            temporaryTableDropWork.execute(connection);
        }
        finally {
            try {
                connectionAccess.releaseConnection(connection);
            }
            catch (SQLException sQLException) {}
        }
    }

    public TemporaryTable getTemporaryTable() {
        return this.temporaryTable;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }
}

