/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.model.domain.BagPersistentAttribute;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ListPersistentAttribute;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SetPersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaEntityJoin;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmAttributeJoin;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public abstract class AbstractSqmFrom<O, T>
extends AbstractSqmPath<T>
implements SqmFrom<O, T> {
    private String alias;
    private List<SqmJoin<T, ?>> joins;
    private List<SqmFrom<?, ?>> treats;

    protected AbstractSqmFrom(NavigablePath navigablePath, SqmPathSource<T> referencedNavigable, SqmFrom<?, ?> lhs, String alias, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedNavigable, lhs, nodeBuilder);
        if (lhs == null) {
            throw new IllegalArgumentException("LHS cannot be null");
        }
        this.alias = alias;
    }

    protected AbstractSqmFrom(EntityDomainType<T> entityType, String alias, NodeBuilder nodeBuilder) {
        super(SqmCreationHelper.buildRootNavigablePath(entityType.getHibernateEntityName(), alias), entityType, null, nodeBuilder);
        this.alias = alias;
    }

    protected AbstractSqmFrom(NavigablePath navigablePath, EntityDomainType<T> entityType, String alias, NodeBuilder nodeBuilder) {
        super(navigablePath, entityType, null, nodeBuilder);
        this.alias = alias;
    }

    protected AbstractSqmFrom(NavigablePath navigablePath, SqmPathSource<T> referencedNavigable, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedNavigable, null, nodeBuilder);
    }

    @Override
    public String getExplicitAlias() {
        return this.alias;
    }

    @Override
    public void setExplicitAlias(String explicitAlias) {
        this.alias = explicitAlias;
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        SqmJoin<T, ?> resolvedPath = null;
        Object modelPartContainer = null;
        for (SqmJoin<T, ?> sqmJoin : this.getSqmJoins()) {
            SqmAttributeJoin attributeJoin;
            if (!(sqmJoin instanceof SqmAttributeJoin) || !name.equals(sqmJoin.getReferencedPathSource().getPathName()) || (attributeJoin = (SqmAttributeJoin)sqmJoin).getOn() != null) continue;
            resolvedPath = sqmJoin;
            if (!attributeJoin.isFetched()) continue;
            break;
        }
        if (resolvedPath != null) {
            return resolvedPath;
        }
        JpaPath sqmPath = this.get(name);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register((SqmPath<?>)sqmPath);
        return sqmPath;
    }

    private ModelPartContainer findModelPartContainer(SqmAttributeJoin<?, ?> attributeJoin, SqmCreationState creationState) {
        String entityName;
        SqmPath lhs = attributeJoin.getLhs();
        if (lhs instanceof SqmAttributeJoin) {
            SqmAttributeJoin lhsAttributeJoin = (SqmAttributeJoin)lhs;
            if (lhsAttributeJoin.getReferencedPathSource() instanceof EntityDomainType) {
                String entityName2 = ((EntityDomainType)lhsAttributeJoin.getReferencedPathSource()).getHibernateEntityName();
                return (ModelPartContainer)creationState.getCreationContext().getQueryEngine().getTypeConfiguration().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName2).findSubPart(attributeJoin.getAttribute().getName(), null);
            }
            return (ModelPartContainer)this.findModelPartContainer(lhsAttributeJoin, creationState).findSubPart(attributeJoin.getAttribute().getName(), null);
        }
        if (lhs instanceof SqmRoot) {
            entityName = ((SqmRoot)lhs).getEntityName();
        } else if (lhs instanceof SqmEntityJoin) {
            entityName = ((SqmEntityJoin)lhs).getEntityName();
        } else {
            assert (lhs instanceof SqmCrossJoin);
            entityName = ((SqmCrossJoin)lhs).getEntityName();
        }
        return (ModelPartContainer)creationState.getCreationContext().getQueryEngine().getTypeConfiguration().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityName).findSubPart(attributeJoin.getAttribute().getName(), null);
    }

    @Override
    public boolean hasJoins() {
        return this.joins != null && !this.joins.isEmpty();
    }

    @Override
    public List<SqmJoin<T, ?>> getSqmJoins() {
        return this.joins == null ? Collections.emptyList() : Collections.unmodifiableList(this.joins);
    }

    @Override
    public void addSqmJoin(SqmJoin<T, ?> join) {
        if (this.joins == null) {
            this.joins = new ArrayList();
        }
        this.joins.add(join);
        this.findRoot().addOrderedJoin(join);
    }

    @Override
    public void visitSqmJoins(Consumer<SqmJoin<T, ?>> consumer) {
        if (this.joins != null) {
            this.joins.forEach(consumer);
        }
    }

    @Override
    public boolean hasTreats() {
        return this.treats != null && !this.treats.isEmpty();
    }

    @Override
    public List<SqmFrom<?, ?>> getSqmTreats() {
        return this.treats == null ? Collections.emptyList() : this.treats;
    }

    protected <S, X extends SqmFrom<?, S>> X findTreat(EntityDomainType<S> targetType, String alias) {
        if (this.treats != null) {
            for (SqmFrom<?, ?> treat : this.treats) {
                if (treat.getModel() != targetType || (treat.getExplicitAlias() != null || alias != null) && !Objects.equals(treat.getExplicitAlias(), alias)) continue;
                return (X)treat;
            }
        }
        return null;
    }

    protected <X extends SqmFrom<?, ?>> X addTreat(X treat) {
        if (this.treats == null) {
            this.treats = new ArrayList();
        }
        this.treats.add(treat);
        return treat;
    }

    @Override
    public JpaPath<?> getParentPath() {
        return this.getLhs();
    }

    @Override
    public SqmFrom<O, T> getCorrelationParent() {
        throw new IllegalStateException("Not correlated");
    }

    public abstract SqmCorrelation<O, T> createCorrelation();

    @Override
    public boolean isCorrelated() {
        return false;
    }

    @Override
    public Set<Join<T, ?>> getJoins() {
        return this.getSqmJoins().stream().filter(sqmJoin -> !(sqmJoin instanceof SqmAttributeJoin) || !((SqmAttributeJoin)sqmJoin).isFetched()).collect(Collectors.toSet());
    }

    @Override
    public <A> SqmSingularJoin<T, A> join(SingularAttribute<? super T, A> attribute) {
        return this.join((SingularAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <A> SqmSingularJoin<T, A> join(SingularAttribute<? super T, A> attribute, JoinType jt) {
        SqmSingularJoin<T, A> join = this.buildSingularJoin((SingularPersistentAttribute)attribute, SqmJoinType.from(jt), false);
        this.addSqmJoin(join);
        return join;
    }

    @Override
    public <A> SqmBagJoin<T, A> join(CollectionAttribute<? super T, A> attribute) {
        return this.join(attribute, JoinType.INNER);
    }

    @Override
    public <E> SqmBagJoin<T, E> join(CollectionAttribute<? super T, E> attribute, JoinType jt) {
        SqmBagJoin<T, E> join = this.buildBagJoin((BagPersistentAttribute)attribute, SqmJoinType.from(jt), false);
        this.addSqmJoin(join);
        return join;
    }

    @Override
    public <E> SqmSetJoin<T, E> join(SetAttribute<? super T, E> attribute) {
        return this.join((SetAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <E> SqmSetJoin<T, E> join(SetAttribute<? super T, E> attribute, JoinType jt) {
        SqmSetJoin<T, E> join = this.buildSetJoin((SetPersistentAttribute)attribute, SqmJoinType.from(jt), false);
        this.addSqmJoin(join);
        return join;
    }

    @Override
    public <E> SqmListJoin<T, E> join(ListAttribute<? super T, E> attribute) {
        return this.join((ListAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <E> SqmListJoin<T, E> join(ListAttribute<? super T, E> attribute, JoinType jt) {
        SqmListJoin<T, E> join = this.buildListJoin((ListPersistentAttribute)attribute, SqmJoinType.from(jt), false);
        this.addSqmJoin(join);
        return join;
    }

    @Override
    public <K, V> SqmMapJoin<T, K, V> join(MapAttribute<? super T, K, V> attribute) {
        return this.join((MapAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <K, V> SqmMapJoin<T, K, V> join(MapAttribute<? super T, K, V> attribute, JoinType jt) {
        SqmMapJoin<T, K, V> join = this.buildMapJoin((MapPersistentAttribute)attribute, SqmJoinType.from(jt), false);
        this.addSqmJoin(join);
        return join;
    }

    @Override
    public <X, Y> SqmAttributeJoin<X, Y> join(String attributeName) {
        return this.join(attributeName, JoinType.INNER);
    }

    @Override
    public <X, Y> SqmAttributeJoin<X, Y> join(String attributeName, JoinType jt) {
        SqmPathSource<?> subPathSource = this.getReferencedPathSource().getSubPathSource(attributeName);
        return this.buildJoin(subPathSource, SqmJoinType.from(jt), false);
    }

    @Override
    public <X, Y> SqmBagJoin<X, Y> joinCollection(String attributeName) {
        return this.joinCollection(attributeName, JoinType.INNER);
    }

    @Override
    public <X, Y> SqmBagJoin<X, Y> joinCollection(String attributeName, JoinType jt) {
        SqmPathSource<?> joinedPathSource = this.getReferencedPathSource().getSubPathSource(attributeName);
        if (joinedPathSource instanceof BagPersistentAttribute) {
            SqmBagJoin join = this.buildBagJoin((BagPersistentAttribute)joinedPathSource, SqmJoinType.from(jt), false);
            this.addSqmJoin(join);
            return join;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute name [%s] did not correspond to a collection (bag) reference [%s] relative to %s", attributeName, joinedPathSource, this.getNavigablePath().getFullPath()));
    }

    @Override
    public <X, Y> SqmSetJoin<X, Y> joinSet(String attributeName) {
        return this.joinSet(attributeName, JoinType.INNER);
    }

    @Override
    public <X, Y> SqmSetJoin<X, Y> joinSet(String attributeName, JoinType jt) {
        SqmPathSource<?> joinedPathSource = this.getReferencedPathSource().getSubPathSource(attributeName);
        if (joinedPathSource instanceof SetPersistentAttribute) {
            SqmSetJoin join = this.buildSetJoin((SetPersistentAttribute)joinedPathSource, SqmJoinType.from(jt), false);
            this.addSqmJoin(join);
            return join;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute name [%s] did not correspond to a collection (set) reference [%s] relative to %s", attributeName, joinedPathSource, this.getNavigablePath().getFullPath()));
    }

    @Override
    public <X, Y> SqmListJoin<X, Y> joinList(String attributeName) {
        return this.joinList(attributeName, JoinType.INNER);
    }

    @Override
    public <X, Y> SqmListJoin<X, Y> joinList(String attributeName, JoinType jt) {
        SqmPathSource<?> joinedPathSource = this.getReferencedPathSource().getSubPathSource(attributeName);
        if (joinedPathSource instanceof ListPersistentAttribute) {
            SqmListJoin join = this.buildListJoin((ListPersistentAttribute)joinedPathSource, SqmJoinType.from(jt), false);
            this.addSqmJoin(join);
            return join;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute name [%s] did not correspond to a collection (list) reference [%s] relative to %s", attributeName, joinedPathSource, this.getNavigablePath().getFullPath()));
    }

    @Override
    public <X, K, V> SqmMapJoin<X, K, V> joinMap(String attributeName) {
        return this.joinMap(attributeName, JoinType.INNER);
    }

    @Override
    public <X, K, V> SqmMapJoin<X, K, V> joinMap(String attributeName, JoinType jt) {
        SqmPathSource<?> joinedPathSource = this.getReferencedPathSource().getSubPathSource(attributeName);
        if (joinedPathSource instanceof MapPersistentAttribute) {
            SqmMapJoin<T, K, V> join = this.buildMapJoin((MapPersistentAttribute)joinedPathSource, SqmJoinType.from(jt), false);
            this.addSqmJoin(join);
            return join;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute name [%s] did not correspond to a collection (map) reference [%s] relative to %s", attributeName, joinedPathSource, this.getNavigablePath().getFullPath()));
    }

    @Override
    public <X> JpaEntityJoin<X> join(Class<X> entityJavaType) {
        return this.join((EntityDomainType<X>)this.nodeBuilder().getDomainModel().entity((Class)entityJavaType));
    }

    @Override
    public <X> JpaEntityJoin<X> join(EntityDomainType<X> entity) {
        return this.join(entity, SqmJoinType.INNER);
    }

    @Override
    public <X> JpaEntityJoin<X> join(Class<X> entityJavaType, SqmJoinType joinType) {
        return this.join((EntityDomainType<X>)this.nodeBuilder().getDomainModel().entity((Class)entityJavaType), joinType);
    }

    @Override
    public <X> JpaEntityJoin<X> join(EntityDomainType<X> entity, SqmJoinType joinType) {
        SqmEntityJoin<X> join = new SqmEntityJoin<X>(entity, null, joinType, this.findRoot());
        this.addSqmJoin(join);
        return join;
    }

    @Override
    public Set<Fetch<T, ?>> getFetches() {
        return this.getSqmJoins().stream().filter(sqmJoin -> sqmJoin instanceof SqmAttributeJoin && ((SqmAttributeJoin)sqmJoin).isFetched()).collect(Collectors.toSet());
    }

    @Override
    public <A> SqmSingularJoin<T, A> fetch(SingularAttribute<? super T, A> attribute) {
        return this.fetch((SingularAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <A> SqmSingularJoin<T, A> fetch(SingularAttribute<? super T, A> attribute, JoinType jt) {
        SqmSingularJoin<T, A> join = this.buildSingularJoin((SingularPersistentAttribute)attribute, SqmJoinType.from(jt), true);
        this.addSqmJoin(join);
        return join;
    }

    @Override
    public <A> SqmAttributeJoin<T, A> fetch(PluralAttribute<? super T, ?, A> attribute) {
        return this.fetch((PluralAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <A> SqmAttributeJoin<T, A> fetch(PluralAttribute<? super T, ?, A> attribute, JoinType jt) {
        return this.buildJoin((PluralPersistentAttribute)attribute, SqmJoinType.from(jt), true);
    }

    @Override
    public <X, A> SqmAttributeJoin<X, A> fetch(String attributeName) {
        return this.fetch(attributeName, JoinType.INNER);
    }

    @Override
    public <X, A> SqmAttributeJoin<X, A> fetch(String attributeName, JoinType jt) {
        SqmPathSource<?> fetchedPathSource = this.getReferencedPathSource().getSubPathSource(attributeName);
        return this.buildJoin(fetchedPathSource, SqmJoinType.from(jt), true);
    }

    private <A> SqmAttributeJoin<T, A> buildJoin(SqmPathSource<A> joinedPathSource, SqmJoinType joinType, boolean fetched) {
        AbstractSqmAttributeJoin sqmJoin;
        if (joinedPathSource instanceof SingularPersistentAttribute) {
            sqmJoin = this.buildSingularJoin((SingularPersistentAttribute)joinedPathSource, joinType, fetched);
        } else if (joinedPathSource instanceof BagPersistentAttribute) {
            sqmJoin = this.buildBagJoin((BagPersistentAttribute)joinedPathSource, joinType, fetched);
        } else if (joinedPathSource instanceof ListPersistentAttribute) {
            sqmJoin = this.buildListJoin((ListPersistentAttribute)joinedPathSource, joinType, fetched);
        } else if (joinedPathSource instanceof MapPersistentAttribute) {
            sqmJoin = this.buildMapJoin((MapPersistentAttribute)joinedPathSource, joinType, fetched);
        } else if (joinedPathSource instanceof SetPersistentAttribute) {
            sqmJoin = this.buildSetJoin((SetPersistentAttribute)joinedPathSource, joinType, fetched);
        } else {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute [%s] did not correspond to a joinable reference [%s] relative to %s", joinedPathSource.getPathName(), joinedPathSource, this.getNavigablePath().getFullPath()));
        }
        this.addSqmJoin(sqmJoin);
        return sqmJoin;
    }

    private <A> SqmSingularJoin<T, A> buildSingularJoin(SingularPersistentAttribute<? super T, A> attribute, SqmJoinType joinType, boolean fetched) {
        if (attribute.getSqmPathType() instanceof ManagedDomainType) {
            return new SqmSingularJoin<T, A>(this, attribute, null, joinType, fetched, (NodeBuilder)this.nodeBuilder());
        }
        throw new SemanticException("Attribute [" + attribute + "] is not joinable");
    }

    private <E> SqmBagJoin<T, E> buildBagJoin(BagPersistentAttribute<? super T, E> attribute, SqmJoinType joinType, boolean fetched) {
        return new SqmBagJoin<T, E>(this, attribute, null, joinType, fetched, (NodeBuilder)this.nodeBuilder());
    }

    private <E> SqmListJoin<T, E> buildListJoin(ListPersistentAttribute<? super T, E> attribute, SqmJoinType joinType, boolean fetched) {
        return new SqmListJoin<T, E>(this, attribute, null, joinType, fetched, (NodeBuilder)this.nodeBuilder());
    }

    private <K, V> SqmMapJoin<T, K, V> buildMapJoin(MapPersistentAttribute<? super T, K, V> attribute, SqmJoinType joinType, boolean fetched) {
        return new SqmMapJoin<T, K, V>(this, attribute, null, joinType, fetched, (NodeBuilder)this.nodeBuilder());
    }

    private <E> SqmSetJoin<T, E> buildSetJoin(SetPersistentAttribute<? super T, E> attribute, SqmJoinType joinType, boolean fetched) {
        return new SqmSetJoin<T, E>(this, attribute, null, joinType, fetched, (NodeBuilder)this.nodeBuilder());
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        if (this.alias == null) {
            sb.append("alias_").append(System.identityHashCode(this));
        } else {
            sb.append(this.alias);
        }
    }

    @Override
    public JpaSelection<T> alias(String name) {
        if (this.getExplicitAlias() == null) {
            this.setExplicitAlias(name);
        }
        return super.alias(name);
    }
}

