/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.criteria.JpaCoalesce;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmCoalesce<T>
extends AbstractSqmExpression<T>
implements JpaCoalesce<T> {
    private final SqmFunctionDescriptor functionDescriptor;
    private final List<SqmExpression<? extends T>> arguments;

    public SqmCoalesce(NodeBuilder nodeBuilder) {
        this((SqmExpressible<T>)null, nodeBuilder);
    }

    public SqmCoalesce(SqmExpressible<T> type, NodeBuilder nodeBuilder) {
        super(type, nodeBuilder);
        this.functionDescriptor = nodeBuilder.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("coalesce");
        this.arguments = new ArrayList<SqmExpression<? extends T>>();
    }

    public SqmCoalesce(SqmExpressible<T> type, int numberOfArguments, NodeBuilder nodeBuilder) {
        super(type, nodeBuilder);
        this.functionDescriptor = nodeBuilder.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("coalesce");
        this.arguments = new ArrayList<SqmExpression<? extends T>>(numberOfArguments);
    }

    public SqmFunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    public void value(SqmExpression<? extends T> expression) {
        this.arguments.add(expression);
    }

    public List<SqmExpression<? extends T>> getArguments() {
        return this.arguments;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCoalesce(this);
    }

    @Override
    public String asLoggableText() {
        return "coalesce(...)";
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("coalesce(");
        this.arguments.get(0).appendHqlString(sb);
        for (int i = 1; i < this.arguments.size(); ++i) {
            sb.append(", ");
            this.arguments.get(i).appendHqlString(sb);
        }
        sb.append(')');
    }

    @Override
    public SqmCoalesce<T> value(T value) {
        this.value(this.nodeBuilder().value(value, this.firstOrNull()));
        return this;
    }

    private SqmExpression<T> firstOrNull() {
        if (CollectionHelper.isEmpty(this.arguments)) {
            return null;
        }
        return this.arguments.get(0);
    }

    @Override
    public SqmCoalesce<T> value(Expression<? extends T> value) {
        this.value((SqmExpression)value);
        return this;
    }

    @Override
    public SqmCoalesce<T> value(JpaExpression<? extends T> value) {
        this.value((SqmExpression)value);
        return this;
    }

    @Override
    public SqmCoalesce<T> values(T ... values) {
        SqmExpression<T> firstOrNull = this.firstOrNull();
        for (T value : values) {
            this.value(this.nodeBuilder().value(value, firstOrNull));
        }
        return this;
    }
}

