/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.BindableType;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.type.descriptor.java.JdbcDateJavaType;
import org.hibernate.type.descriptor.java.JdbcTimeJavaType;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmExpressionHelper {
    public static <T> SqmExpressible<T> toSqmType(BindableType<T> parameterType, SqmCreationState creationState) {
        return SqmExpressionHelper.toSqmType(parameterType, creationState.getCreationContext().getJpaMetamodel().getTypeConfiguration());
    }

    public static <T> SqmExpressible<T> toSqmType(BindableType<T> anticipatedType, NodeBuilder nodeBuilder) {
        return SqmExpressionHelper.toSqmType(anticipatedType, nodeBuilder.getTypeConfiguration());
    }

    public static <T> SqmExpressible<T> toSqmType(BindableType<T> anticipatedType, TypeConfiguration typeConfiguration) {
        return SqmExpressionHelper.toSqmType(anticipatedType, typeConfiguration.getSessionFactory());
    }

    public static <T> SqmExpressible<T> toSqmType(BindableType<T> anticipatedType, SessionFactoryImplementor sessionFactory) {
        if (anticipatedType == null) {
            return null;
        }
        SqmExpressible<T> sqmExpressible = anticipatedType.resolveExpressible(sessionFactory);
        assert (sqmExpressible != null);
        return sqmExpressible;
    }

    public static SqmLiteral<Timestamp> timestampLiteralFrom(String literalText, SqmCreationState creationState) {
        Timestamp literal = Timestamp.valueOf(LocalDateTime.from(JdbcTimestampJavaType.LITERAL_FORMATTER.parse(literalText)));
        return new SqmLiteral<Timestamp>(literal, creationState.getCreationContext().getJpaMetamodel().getTypeConfiguration().standardBasicTypeForJavaType(Timestamp.class), creationState.getCreationContext().getQueryEngine().getCriteriaBuilder());
    }

    public static SqmLiteral<Integer> integerLiteral(String literalText, SqmCreationState creationState) {
        return SqmExpressionHelper.integerLiteral(literalText, creationState.getCreationContext().getQueryEngine());
    }

    public static SqmLiteral<Integer> integerLiteral(String literalText, QueryEngine queryEngine) {
        return SqmExpressionHelper.integerLiteral(Integer.parseInt(literalText), queryEngine);
    }

    public static SqmLiteral<Integer> integerLiteral(int value, QueryEngine queryEngine) {
        return new SqmLiteral<Integer>(value, queryEngine.getCriteriaBuilder().getIntegerType(), queryEngine.getCriteriaBuilder());
    }

    public static SqmLiteral<Date> dateLiteralFrom(String literalText, SqmCreationState creationState) {
        LocalDate localDate = LocalDate.from(JdbcDateJavaType.LITERAL_FORMATTER.parse(literalText));
        Date literal = new Date(localDate.toEpochDay());
        return new SqmLiteral<Date>(literal, creationState.getCreationContext().getJpaMetamodel().getTypeConfiguration().standardBasicTypeForJavaType(Date.class), creationState.getCreationContext().getQueryEngine().getCriteriaBuilder());
    }

    public static SqmLiteral<Time> timeLiteralFrom(String literalText, SqmCreationState creationState) {
        LocalTime localTime = LocalTime.from(JdbcTimeJavaType.LITERAL_FORMATTER.parse(literalText));
        Time literal = Time.valueOf(localTime);
        return new SqmLiteral<Time>(literal, creationState.getCreationContext().getJpaMetamodel().getTypeConfiguration().standardBasicTypeForJavaType(Time.class), creationState.getCreationContext().getQueryEngine().getCriteriaBuilder());
    }
}

