/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.expression.AbstractSqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;

public class SqmPositionalParameter<T>
extends AbstractSqmParameter<T> {
    private final int position;

    public SqmPositionalParameter(int position, boolean canBeMultiValued, NodeBuilder nodeBuilder) {
        this(position, canBeMultiValued, null, nodeBuilder);
    }

    public SqmPositionalParameter(int position, boolean canBeMultiValued, SqmExpressible<T> expressibleType, NodeBuilder nodeBuilder) {
        super(canBeMultiValued, expressibleType, nodeBuilder);
        this.position = position;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public SqmParameter<T> copy() {
        return new SqmPositionalParameter(this.getPosition(), this.allowMultiValuedBinding(), this.getNodeType(), this.nodeBuilder());
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitPositionalParameterExpression(this);
    }

    public String toString() {
        return "SqmPositionalParameter(" + this.getPosition() + ")";
    }

    @Override
    public String asLoggableText() {
        return "?" + this.getPosition();
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append('?');
        sb.append(this.getPosition());
    }
}

