/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast;

import java.util.List;
import org.hibernate.sql.ast.tree.SqlAstTreeLogger;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.UpdateStatement;

public class SqlTreePrinter {
    private final StringBuffer buffer = new StringBuffer();
    private int depth = 2;

    public static void logSqlAst(Statement sqlAstStatement) {
        if (!SqlAstTreeLogger.DEBUG_ENABLED) {
            return;
        }
        SqlTreePrinter printer = new SqlTreePrinter();
        printer.visitStatement(sqlAstStatement);
        SqlAstTreeLogger.INSTANCE.debugf("SQL AST Tree:%n" + printer.buffer.toString(), new Object[0]);
    }

    private SqlTreePrinter() {
    }

    private void visitStatement(Statement sqlAstStatement) {
        if (sqlAstStatement instanceof SelectStatement) {
            SelectStatement selectStatement = (SelectStatement)sqlAstStatement;
            this.logNode("SelectStatement", () -> this.visitQueryPart(selectStatement.getQueryPart()));
        } else if (sqlAstStatement instanceof DeleteStatement) {
            DeleteStatement deleteStatement = (DeleteStatement)sqlAstStatement;
            this.logNode("DeleteStatement", () -> this.logWithIndentation("target : " + deleteStatement.getTargetTable().getTableExpression()));
        } else if (sqlAstStatement instanceof UpdateStatement) {
            UpdateStatement updateStatement = (UpdateStatement)sqlAstStatement;
            this.logNode("UpdateStatement", () -> this.logWithIndentation("target : " + updateStatement.getTargetTable().getTableExpression()));
        } else if (sqlAstStatement instanceof InsertStatement) {
            InsertStatement insertStatement = (InsertStatement)sqlAstStatement;
            this.logNode("InsertStatement", () -> this.logWithIndentation("target : " + insertStatement.getTargetTable().getTableExpression()));
        } else {
            throw new UnsupportedOperationException("Printing for this type of SQL AST not supported : " + sqlAstStatement);
        }
    }

    private void visitQueryPart(QueryPart queryPart) {
        if (queryPart instanceof QueryGroup) {
            this.visitQueryGroup((QueryGroup)queryPart);
        } else {
            this.visitQuerySpec((QuerySpec)queryPart);
        }
    }

    private void visitQueryGroup(QueryGroup queryGroup) {
        this.logNode("QueryGroup: " + queryGroup.getSetOperator(), () -> {
            for (QueryPart queryPart : queryGroup.getQueryParts()) {
                this.visitQueryPart(queryPart);
            }
        });
    }

    private void visitQuerySpec(QuerySpec querySpec) {
        this.visitFromClause(querySpec.getFromClause());
    }

    private void visitFromClause(FromClause fromClause) {
        this.logNode("FromClause", () -> fromClause.visitRoots(this::visitTableGroup));
    }

    private void visitTableGroup(TableGroup tableGroup) {
        this.logNode(this.toDisplayText(tableGroup), () -> this.logTableGroupDetails(tableGroup));
    }

    private String toDisplayText(TableGroup tableGroup) {
        return tableGroup.getClass().getSimpleName() + " (" + tableGroup.getGroupAlias() + " : " + tableGroup.getNavigablePath() + ")";
    }

    private void logTableGroupDetails(TableGroup tableGroup) {
        List<TableGroupJoin> tableGroupJoins;
        List<TableGroupJoin> nestedTableGroupJoins;
        if (tableGroup instanceof LazyTableGroup) {
            TableGroup underlyingTableGroup = ((LazyTableGroup)tableGroup).getUnderlyingTableGroup();
            if (underlyingTableGroup != null) {
                this.logTableGroupDetails(underlyingTableGroup);
            }
            return;
        }
        if (tableGroup.getPrimaryTableReference() instanceof NamedTableReference) {
            this.logWithIndentation("primaryTableReference : %s as %s", tableGroup.getPrimaryTableReference().getTableId(), tableGroup.getPrimaryTableReference().getIdentificationVariable());
        } else if (tableGroup.getPrimaryTableReference() instanceof ValuesTableReference) {
            this.logWithIndentation("primaryTableReference : values (..) as %s", tableGroup.getPrimaryTableReference().getIdentificationVariable());
        } else if (tableGroup.getPrimaryTableReference() instanceof FunctionTableReference) {
            this.logWithIndentation("primaryTableReference : %s(...) as %s", ((FunctionTableReference)tableGroup.getPrimaryTableReference()).getFunctionExpression().getFunctionName(), tableGroup.getPrimaryTableReference().getIdentificationVariable());
        } else {
            this.logNode("PrimaryTableReference as " + tableGroup.getPrimaryTableReference().getIdentificationVariable(), () -> {
                QueryPart queryPart = ((QueryPartTableReference)tableGroup.getPrimaryTableReference()).getQueryPart();
                this.visitQueryPart(queryPart);
            });
        }
        List<TableReferenceJoin> tableReferenceJoins = tableGroup.getTableReferenceJoins();
        if (!tableReferenceJoins.isEmpty()) {
            this.logNode("TableReferenceJoins", () -> {
                for (TableReferenceJoin join : tableReferenceJoins) {
                    this.logWithIndentation("%s join %s as %s", join.getJoinType().getText(), join.getJoinedTableReference().getTableExpression(), join.getJoinedTableReference().getIdentificationVariable());
                }
            });
        }
        if (!(nestedTableGroupJoins = tableGroup.getNestedTableGroupJoins()).isEmpty()) {
            this.logNode("NestedTableGroupJoins", () -> tableGroup.visitNestedTableGroupJoins(this::visitTableGroupJoin));
        }
        if (!(tableGroupJoins = tableGroup.getTableGroupJoins()).isEmpty()) {
            this.logNode("TableGroupJoins", () -> tableGroup.visitTableGroupJoins(this::visitTableGroupJoin));
        }
    }

    private void visitTableGroupJoin(TableGroupJoin tableGroupJoin) {
        this.logNode(tableGroupJoin.getJoinType().getText() + " join " + this.toDisplayText(tableGroupJoin.getJoinedGroup()), () -> this.logTableGroupDetails(tableGroupJoin.getJoinedGroup()));
    }

    private void logNode(String text) {
        this.logWithIndentation("%s", text);
    }

    private void logNode(String text, Runnable subTreeHandler) {
        this.logNode(text, subTreeHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logNode(String text, Runnable subTreeHandler, boolean indentContinuation) {
        this.logWithIndentation("%s {", text);
        ++this.depth;
        try {
            if (indentContinuation) {
                ++this.depth;
            }
            subTreeHandler.run();
        }
        catch (Exception e) {
            SqlAstTreeLogger.INSTANCE.debugf((Throwable)e, "Error processing node {%s}", (Object)text);
        }
        finally {
            if (indentContinuation) {
                --this.depth;
            }
        }
        --this.depth;
        this.logWithIndentation("}", text);
    }

    private void logWithIndentation(Object line) {
        this.pad(this.depth);
        this.buffer.append(line).append(System.lineSeparator());
    }

    private void logWithIndentation(String pattern, Object arg1) {
        this.logWithIndentation(String.format(pattern, arg1));
    }

    private void logWithIndentation(String pattern, Object arg1, Object arg2) {
        this.logWithIndentation(String.format(pattern, arg1, arg2));
    }

    private void logWithIndentation(String pattern, Object arg1, Object arg2, Object arg3) {
        this.logWithIndentation(String.format(pattern, arg1, arg2, arg3));
    }

    private void pad(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.buffer.append("  ");
        }
    }
}

