/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.tuple.TupleResult;
import org.hibernate.type.descriptor.java.JavaType;

public class SqlTuple
implements Expression,
SqlTupleContainer,
DomainResultProducer {
    private final List<? extends Expression> expressions;
    private final MappingModelExpressible valueMapping;

    public SqlTuple(List<? extends Expression> expressions, MappingModelExpressible valueMapping) {
        this.expressions = expressions;
        this.valueMapping = valueMapping;
        if (expressions.size() < 2) {
            SqlTreeCreationLogger.LOGGER.debugf("SqlTuple created with `%s` expression(s)", expressions.size());
        }
    }

    @Override
    public MappingModelExpressible getExpressionType() {
        return this.valueMapping;
    }

    public List<? extends Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTuple(this);
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this;
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        JavaType javaType = ((SqmExpressible)((Object)this.valueMapping)).getExpressibleJavaType();
        int[] valuesArrayPositions = new int[this.expressions.size()];
        for (int i = 0; i < this.expressions.size(); ++i) {
            valuesArrayPositions[i] = creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this.expressions.get(i), javaType, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration()).getValuesArrayPosition();
        }
        return new TupleResult(valuesArrayPositions, resultVariable, javaType);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    public static class Builder {
        private final MappingModelExpressible valueMapping;
        private List<Expression> expressions;

        public Builder(MappingModelExpressible valueMapping) {
            this.valueMapping = valueMapping;
        }

        public Builder(MappingModelExpressible valueMapping, int jdbcTypeCount) {
            this(valueMapping);
            this.expressions = new ArrayList<Expression>(jdbcTypeCount);
        }

        public void addSubExpression(Expression expression) {
            if (this.expressions == null) {
                this.expressions = new ArrayList<Expression>();
            }
            this.expressions.add(expression);
        }

        public SqlTuple buildTuple() {
            return new SqlTuple(this.expressions == null ? Collections.emptyList() : this.expressions, this.valueMapping);
        }
    }
}

