/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;

public class CorrelatedTableGroup
extends AbstractTableGroup {
    private final TableGroup correlatedTableGroup;
    private final QuerySpec querySpec;
    private final Consumer<Predicate> joinPredicateConsumer;

    public CorrelatedTableGroup(TableGroup correlatedTableGroup, SqlAliasBase sqlAliasBase, QuerySpec querySpec, Consumer<Predicate> joinPredicateConsumer, SessionFactoryImplementor sessionFactory) {
        super(true, correlatedTableGroup.getNavigablePath(), (TableGroupProducer)correlatedTableGroup.getExpressionType(), null, sqlAliasBase, sessionFactory);
        this.correlatedTableGroup = correlatedTableGroup;
        this.querySpec = querySpec;
        this.joinPredicateConsumer = joinPredicateConsumer;
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        assert (!this.getTableGroupJoins().contains(join));
        assert (join.getJoinType() == SqlAstJoinType.INNER);
        this.querySpec.getFromClause().addRoot(join.getJoinedGroup());
        this.joinPredicateConsumer.accept(join.getPredicate());
        super.addTableGroupJoin(join);
    }

    @Override
    public void prependTableGroupJoin(NavigablePath navigablePath, TableGroupJoin join) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNestedTableGroupJoin(TableGroupJoin join) {
        assert (!this.getTableGroupJoins().contains(join));
        assert (join.getJoinType() == SqlAstJoinType.INNER);
        this.querySpec.getFromClause().addRoot(join.getJoinedGroup());
        this.joinPredicateConsumer.accept(join.getPredicate());
        super.addNestedTableGroupJoin(join);
    }

    @Override
    protected TableReference getTableReferenceInternal(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        TableReference groupTableReference;
        TableReference tableReference = this.correlatedTableGroup.getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
        if (tableReference != null) {
            return tableReference;
        }
        for (TableGroupJoin tableGroupJoin : this.getNestedTableGroupJoins()) {
            groupTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
            if (groupTableReference == null) continue;
            return groupTableReference;
        }
        for (TableGroupJoin tableGroupJoin : this.getTableGroupJoins()) {
            groupTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
            if (groupTableReference == null) continue;
            return groupTableReference;
        }
        return null;
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        this.getPrimaryTableReference().applyAffectedTableNames(nameCollector);
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.correlatedTableGroup.getPrimaryTableReference();
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }
}

