/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.internal.ScrollableResultsIterator;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.sql.exec.SqlExecLogger;
import org.hibernate.sql.exec.internal.JdbcExecHelper;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.results.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.results.jdbc.internal.DeferredResultSetAccess;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesCacheHit;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesResultSetImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.ResultSetAccess;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.sql.results.spi.ScrollableResultsConsumer;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class JdbcSelectExecutorStandardImpl
implements JdbcSelectExecutor {
    public static final JdbcSelectExecutorStandardImpl INSTANCE = new JdbcSelectExecutorStandardImpl();

    @Override
    public <R> List<R> list(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, ListResultsConsumer.UniqueSemantic uniqueSemantic) {
        return (List)this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), ListResultsConsumer.instance(uniqueSemantic));
    }

    @Override
    public <R> ScrollableResultsImplementor<R> scroll(JdbcSelect jdbcSelect, ScrollMode scrollMode, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        SharedSessionContractImplementor session = executionContext.getSession();
        session.autoFlushIfRequired(jdbcSelect.getAffectedTableNames());
        return (ScrollableResultsImplementor)this.executeQueryScroll(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareQueryStatement((String)sql, false, scrollMode), ScrollableResultsConsumer.instance());
    }

    @Override
    public <R> Stream<R> stream(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        ScrollableResultsImplementor<R> scrollableResults = this.scroll(jdbcSelect, ScrollMode.FORWARD_ONLY, jdbcParameterBindings, executionContext, rowTransformer);
        ScrollableResultsIterator<R> iterator = new ScrollableResultsIterator<R>(scrollableResults);
        Spliterator<R> spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        Stream<R> stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(scrollableResults::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R> T executeQuery(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Function<String, PreparedStatement> statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        PersistenceContext persistenceContext = executionContext.getSession().getPersistenceContext();
        boolean defaultReadOnlyOrig = persistenceContext.isDefaultReadOnly();
        Boolean readOnly = executionContext.getQueryOptions().isReadOnly();
        if (readOnly != null) {
            persistenceContext.setDefaultReadOnly(readOnly);
        }
        try {
            T t = this.doExecuteQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, statementCreator, resultsConsumer);
            return t;
        }
        finally {
            if (readOnly != null) {
                persistenceContext.setDefaultReadOnly(defaultReadOnlyOrig);
            }
        }
    }

    private <T, R> T executeQueryScroll(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Function<String, PreparedStatement> statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        return this.doExecuteQuery(jdbcSelect, jdbcParameterBindings, this.getScrollContext(executionContext, executionContext.getSession().getPersistenceContext()), rowTransformer, statementCreator, resultsConsumer);
    }

    private ExecutionContext getScrollContext(final ExecutionContext context, PersistenceContext persistenceContext) {
        QueryOptions queryOptions = context.getQueryOptions();
        final Boolean readOnly = queryOptions.isReadOnly() == null ? Boolean.valueOf(persistenceContext.isDefaultReadOnly()) : queryOptions.isReadOnly();
        final Integer timeout = queryOptions.getTimeout();
        final FlushMode flushMode = queryOptions.getFlushMode();
        final AppliedGraph appliedGraph = queryOptions.getAppliedGraph();
        final TupleTransformer<?> tupleTransformer = queryOptions.getTupleTransformer();
        final ResultListTransformer<?> resultListTransformer = queryOptions.getResultListTransformer();
        final Boolean resultCachingEnabled = queryOptions.isResultCachingEnabled();
        final CacheRetrieveMode cacheRetrieveMode = queryOptions.getCacheRetrieveMode();
        final CacheStoreMode cacheStoreMode = queryOptions.getCacheStoreMode();
        final String resultCacheRegionName = queryOptions.getResultCacheRegionName();
        final LockOptions lockOptions = queryOptions.getLockOptions();
        final String comment = queryOptions.getComment();
        final List<String> databaseHints = queryOptions.getDatabaseHints();
        final Integer fetchSize = queryOptions.getFetchSize();
        final Limit limit = queryOptions.getLimit();
        return new ExecutionContext(){

            @Override
            public QueryOptions getQueryOptions() {
                return new QueryOptions(){

                    @Override
                    public Integer getTimeout() {
                        return timeout;
                    }

                    @Override
                    public FlushMode getFlushMode() {
                        return flushMode;
                    }

                    @Override
                    public Boolean isReadOnly() {
                        return readOnly;
                    }

                    @Override
                    public AppliedGraph getAppliedGraph() {
                        return appliedGraph;
                    }

                    @Override
                    public TupleTransformer<?> getTupleTransformer() {
                        return tupleTransformer;
                    }

                    @Override
                    public ResultListTransformer<?> getResultListTransformer() {
                        return resultListTransformer;
                    }

                    @Override
                    public Boolean isResultCachingEnabled() {
                        return resultCachingEnabled;
                    }

                    @Override
                    public CacheRetrieveMode getCacheRetrieveMode() {
                        return cacheRetrieveMode;
                    }

                    @Override
                    public CacheStoreMode getCacheStoreMode() {
                        return cacheStoreMode;
                    }

                    @Override
                    public String getResultCacheRegionName() {
                        return resultCacheRegionName;
                    }

                    @Override
                    public LockOptions getLockOptions() {
                        return lockOptions;
                    }

                    @Override
                    public String getComment() {
                        return comment;
                    }

                    @Override
                    public List<String> getDatabaseHints() {
                        return databaseHints;
                    }

                    @Override
                    public Integer getFetchSize() {
                        return fetchSize;
                    }

                    @Override
                    public Limit getLimit() {
                        return limit;
                    }
                };
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return context.getQueryParameterBindings();
            }

            @Override
            public Callback getCallback() {
                return context.getCallback();
            }

            @Override
            public SharedSessionContractImplementor getSession() {
                return context.getSession();
            }
        };
    }

    private <T, R> T doExecuteQuery(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, final ExecutionContext executionContext, RowTransformer<R> rowTransformer, Function<String, PreparedStatement> statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        boolean stats;
        DeferredResultSetAccess deferredResultSetAccess = new DeferredResultSetAccess(jdbcSelect, jdbcParameterBindings, executionContext, statementCreator);
        JdbcValues jdbcValues = this.resolveJdbcValuesSource(executionContext.getQueryIdentifier(deferredResultSetAccess.getFinalSql()), jdbcSelect, resultsConsumer.canResultsBeCached(), executionContext, deferredResultSetAccess);
        if (rowTransformer == null) {
            TupleTransformer<?> tupleTransformer = executionContext.getQueryOptions().getTupleTransformer();
            if (tupleTransformer == null) {
                rowTransformer = RowTransformerPassThruImpl.instance();
            } else {
                List<DomainResult<?>> domainResults = jdbcValues.getValuesMapping().getDomainResults();
                String[] aliases = new String[domainResults.size()];
                for (int i = 0; i < domainResults.size(); ++i) {
                    aliases[i] = domainResults.get(i).getResultVariable();
                }
                rowTransformer = new RowTransformerTupleTransformerAdapter(aliases, tupleTransformer);
            }
        }
        long startTime = 0L;
        StatisticsImplementor statistics = executionContext.getSession().getFactory().getStatistics();
        if (executionContext.hasQueryExecutionToBeAddedToStatistics() && jdbcValues instanceof JdbcValuesResultSetImpl) {
            stats = statistics.isStatisticsEnabled();
            if (stats) {
                startTime = System.nanoTime();
            }
        } else {
            stats = false;
        }
        JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

            @Override
            public Object getEffectiveOptionalObject() {
                return executionContext.getEntityInstance();
            }

            @Override
            public String getEffectiveOptionalEntityName() {
                return null;
            }

            @Override
            public Object getEffectiveOptionalId() {
                return executionContext.getEntityId();
            }

            @Override
            public boolean shouldReturnProxies() {
                return true;
            }
        };
        JdbcValuesSourceProcessingStateStandardImpl valuesProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(executionContext, processingOptions, executionContext::registerLoadingEntityEntry);
        RowReader<R> rowReader = ResultsHelper.createRowReader(executionContext, deferredResultSetAccess.usesFollowOnLocking() ? LockOptions.NONE : executionContext.getQueryOptions().getLockOptions(), rowTransformer, jdbcValues);
        RowProcessingStateStandardImpl rowProcessingState = new RowProcessingStateStandardImpl(valuesProcessingState, executionContext, rowReader, jdbcValues);
        T result = resultsConsumer.consume(jdbcValues, executionContext.getSession(), processingOptions, valuesProcessingState, rowProcessingState, rowReader);
        if (stats) {
            long endTime = System.nanoTime();
            long milliseconds = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            statistics.queryExecuted(executionContext.getQueryIdentifier(jdbcSelect.getSql()), this.getResultSize(result), milliseconds);
        }
        return result;
    }

    private <T> int getResultSize(T result) {
        if (result instanceof List) {
            return ((List)result).size();
        }
        return -1;
    }

    private JdbcValues resolveJdbcValuesSource(String queryIdentifier, JdbcSelect jdbcSelect, boolean canBeCached, ExecutionContext executionContext, ResultSetAccess resultSetAccess) {
        List<?> cachedResults;
        QueryKey queryResultsCacheKey;
        boolean cacheable;
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        boolean queryCacheEnabled = factory.getSessionFactoryOptions().isQueryCacheEnabled();
        CacheMode cacheMode = JdbcExecHelper.resolveCacheMode(executionContext);
        JdbcValuesMappingProducer mappingProducer = jdbcSelect.getJdbcValuesMappingProducer();
        boolean bl = cacheable = queryCacheEnabled && canBeCached && executionContext.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE;
        if (cacheable && cacheMode.isGetEnabled()) {
            SqlExecLogger.INSTANCE.debugf("Reading Query result cache data per CacheMode#isGetEnabled [%s]", (Object)cacheMode.name());
            Set<String> querySpaces = jdbcSelect.getAffectedTableNames();
            if (querySpaces == null || querySpaces.size() == 0) {
                SqlExecLogger.INSTANCE.tracev("Unexpected querySpaces is {0}", querySpaces == null ? querySpaces : "empty");
            } else {
                SqlExecLogger.INSTANCE.tracev("querySpaces is {0}", (Object)querySpaces);
            }
            QueryResultsCache queryCache = factory.getCache().getQueryResultsCache(executionContext.getQueryOptions().getResultCacheRegionName());
            queryResultsCacheKey = QueryKey.from(jdbcSelect.getSql(), executionContext.getQueryOptions().getLimit(), executionContext.getQueryParameterBindings(), session);
            cachedResults = queryCache.get(queryResultsCacheKey, querySpaces, session);
            StatisticsImplementor statistics = factory.getStatistics();
            if (statistics.isStatisticsEnabled()) {
                if (cachedResults == null) {
                    statistics.queryCacheMiss(queryIdentifier, queryCache.getRegion().getName());
                } else {
                    statistics.queryCacheHit(queryIdentifier, queryCache.getRegion().getName());
                }
            }
        } else {
            SqlExecLogger.INSTANCE.debugf("Skipping reading Query result cache data: cache-enabled = %s, cache-mode = %s", (Object)queryCacheEnabled, (Object)cacheMode.name());
            cachedResults = null;
            queryResultsCacheKey = cacheable && cacheMode.isPutEnabled() ? QueryKey.from(jdbcSelect.getSql(), executionContext.getQueryOptions().getLimit(), executionContext.getQueryParameterBindings(), session) : null;
        }
        if (cachedResults == null) {
            JdbcValuesMetadata metadataForCache;
            JdbcValuesMapping jdbcValuesMapping;
            if (queryResultsCacheKey == null) {
                jdbcValuesMapping = mappingProducer.resolve(resultSetAccess, factory);
                metadataForCache = null;
            } else {
                CapturingJdbcValuesMetadata capturingMetadata = new CapturingJdbcValuesMetadata(resultSetAccess);
                jdbcValuesMapping = mappingProducer.resolve(capturingMetadata, factory);
                metadataForCache = capturingMetadata.resolveMetadataForCache();
            }
            return new JdbcValuesResultSetImpl(resultSetAccess, queryResultsCacheKey, queryIdentifier, executionContext.getQueryOptions(), jdbcValuesMapping, metadataForCache, executionContext);
        }
        JdbcValuesMapping jdbcValuesMapping = cachedResults.isEmpty() || !(cachedResults.get(0) instanceof JdbcValuesMetadata) ? mappingProducer.resolve(resultSetAccess, factory) : mappingProducer.resolve((JdbcValuesMetadata)cachedResults.get(0), factory);
        return new JdbcValuesCacheHit(cachedResults, jdbcValuesMapping);
    }

    private static class CachedJdbcValuesMetadata
    implements JdbcValuesMetadata,
    Serializable {
        private final String[] columnNames;
        private final BasicType<?>[] types;

        public CachedJdbcValuesMetadata(String[] columnNames, BasicType<?>[] types) {
            this.columnNames = columnNames;
            this.types = types;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int resolveColumnPosition(String columnName) {
            int position = ArrayHelper.indexOf(this.columnNames, columnName) + 1;
            if (position == 0) {
                throw new IllegalStateException("Unexpected resolving of unavailable column: " + columnName);
            }
            return position;
        }

        @Override
        public String resolveColumnName(int position) {
            String name = this.columnNames[position - 1];
            if (name == null) {
                throw new IllegalStateException("Unexpected resolving of unavailable column at position: " + position);
            }
            return name;
        }

        @Override
        public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, SessionFactoryImplementor sessionFactory) {
            BasicType<?> type = this.types[position - 1];
            if (type == null) {
                throw new IllegalStateException("Unexpected resolving of unavailable column at position: " + position);
            }
            if (explicitJavaType == null || type.getJavaTypeDescriptor() == explicitJavaType) {
                return type;
            }
            return sessionFactory.getTypeConfiguration().getBasicTypeRegistry().resolve(explicitJavaType, type.getJdbcType());
        }
    }

    private static class CapturingJdbcValuesMetadata
    implements JdbcValuesMetadata {
        private final ResultSetAccess resultSetAccess;
        private String[] columnNames;
        private BasicType<?>[] types;

        public CapturingJdbcValuesMetadata(ResultSetAccess resultSetAccess) {
            this.resultSetAccess = resultSetAccess;
        }

        private void initializeArrays() {
            int columnCount = this.resultSetAccess.getColumnCount();
            this.columnNames = new String[columnCount];
            this.types = new BasicType[columnCount];
        }

        @Override
        public int getColumnCount() {
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            return this.columnNames.length;
        }

        @Override
        public int resolveColumnPosition(String columnName) {
            int position;
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            if (this.columnNames == null) {
                position = this.resultSetAccess.resolveColumnPosition(columnName);
                this.columnNames[position - 1] = columnName;
            } else {
                position = ArrayHelper.indexOf(this.columnNames, columnName) + 1;
                if (position == 0) {
                    position = this.resultSetAccess.resolveColumnPosition(columnName);
                    this.columnNames[position - 1] = columnName;
                }
            }
            return position;
        }

        @Override
        public String resolveColumnName(int position) {
            String name;
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            if (this.columnNames == null) {
                this.columnNames[position - 1] = name = this.resultSetAccess.resolveColumnName(position);
            } else {
                name = this.columnNames[position - 1];
                if (name == null) {
                    this.columnNames[position - 1] = name = this.resultSetAccess.resolveColumnName(position);
                }
            }
            return name;
        }

        @Override
        public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, SessionFactoryImplementor sessionFactory) {
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            BasicType<J> basicType = this.resultSetAccess.resolveType(position, explicitJavaType, sessionFactory);
            this.types[position - 1] = basicType;
            return basicType;
        }

        public JdbcValuesMetadata resolveMetadataForCache() {
            if (this.columnNames == null) {
                return null;
            }
            return new CachedJdbcValuesMetadata(this.columnNames, this.types);
        }
    }
}

