/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.basic;

import org.hibernate.Internal;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.basic.BasicResultGraphNode;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicResult<T>
implements DomainResult<T>,
BasicResultGraphNode<T> {
    private final String resultVariable;
    private final JavaType<T> javaType;
    private final NavigablePath navigablePath;
    private final DomainResultAssembler<T> assembler;

    public BasicResult(int jdbcValuesArrayPosition, String resultVariable, JavaType<T> javaType) {
        this(jdbcValuesArrayPosition, resultVariable, javaType, (NavigablePath)null);
    }

    public BasicResult(int jdbcValuesArrayPosition, String resultVariable, JavaType<T> javaType, NavigablePath navigablePath) {
        this.resultVariable = resultVariable;
        this.javaType = javaType;
        this.navigablePath = navigablePath;
        this.assembler = new BasicResultAssembler<T>(jdbcValuesArrayPosition, javaType);
    }

    public BasicResult(int valuesArrayPosition, String resultVariable, JavaType<T> javaType, BasicValueConverter<T, ?> valueConverter) {
        this(valuesArrayPosition, resultVariable, javaType, valueConverter, null);
    }

    public BasicResult(int valuesArrayPosition, String resultVariable, JavaType<T> javaType, BasicValueConverter<T, ?> valueConverter, NavigablePath navigablePath) {
        this.resultVariable = resultVariable;
        this.javaType = javaType;
        this.navigablePath = navigablePath;
        this.assembler = new BasicResultAssembler<T>(valuesArrayPosition, javaType, valueConverter);
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    public JavaType<T> getResultJavaType() {
        return this.javaType;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Internal
    public DomainResultAssembler<T> getAssembler() {
        return this.assembler;
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return this.assembler;
    }
}

