/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.CollectionLoadingLogger;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.collection.internal.AbstractCollectionInitializer;
import org.hibernate.sql.results.internal.LoadingCollectionEntryImpl;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractImmediateCollectionInitializer
extends AbstractCollectionInitializer {
    private final LockMode lockMode;
    private LoadingCollectionEntryImpl responsibility;
    private final DomainResultAssembler<?> collectionValueKeyResultAssembler;
    private Object collectionValueKey;
    private boolean isInitialized;

    public AbstractImmediateCollectionInitializer(NavigablePath collectionPath, PluralAttributeMapping collectionAttributeMapping, FetchParentAccess parentAccess, LockMode lockMode, DomainResultAssembler<?> collectionKeyResultAssembler, DomainResultAssembler<?> collectionValueKeyResultAssembler) {
        super(collectionPath, collectionAttributeMapping, parentAccess, collectionKeyResultAssembler);
        this.collectionValueKeyResultAssembler = collectionValueKeyResultAssembler;
        this.lockMode = lockMode;
    }

    protected abstract String getSimpleConcreteImplName();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        SharedSessionContractImplementor session;
        PersistenceContext persistenceContext;
        block19: {
            LoadingCollectionEntry existingLoadingEntry;
            if (this.collectionInstance != null || this.collectionKey == null) {
                return;
            }
            if (CollectionLoadingLogger.TRACE_ENABLED) {
                CollectionLoadingLogger.COLL_LOAD_LOGGER.tracef("(%s) Beginning Initializer#resolveInstance for collection : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()));
            }
            if ((existingLoadingEntry = (persistenceContext = (session = rowProcessingState.getSession()).getPersistenceContext()).getLoadContexts().findLoadingCollectionEntry(this.collectionKey)) != null) {
                this.collectionInstance = existingLoadingEntry.getCollectionInstance();
                if (CollectionLoadingLogger.DEBUG_ENABLED) {
                    CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Found existing loading collection entry [%s]; using loading collection instance - %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
                }
                if (existingLoadingEntry.getInitializer() == this) {
                    this.responsibility = (LoadingCollectionEntryImpl)existingLoadingEntry;
                    break block19;
                } else {
                    if (CollectionLoadingLogger.DEBUG_ENABLED) {
                        CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Collection [%s] being loaded by another initializer [%s] - skipping processing", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)existingLoadingEntry.getInitializer());
                    }
                    return;
                }
            }
            PersistentCollection<?> existing = persistenceContext.getCollection(this.collectionKey);
            if (existing != null) {
                this.collectionInstance = existing;
                if (this.collectionInstance.wasInitialized()) {
                    if (CollectionLoadingLogger.DEBUG_ENABLED) {
                        CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Found existing collection instance [%s] in Session; skipping processing - [%s]", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
                    }
                    return;
                }
                this.takeResponsibility(rowProcessingState, this.collectionKey);
            } else {
                PersistentCollection<?> existingUnowned = persistenceContext.useUnownedCollection(this.collectionKey);
                if (existingUnowned != null) {
                    this.collectionInstance = existingUnowned;
                    if (this.collectionInstance.wasInitialized()) {
                        if (CollectionLoadingLogger.DEBUG_ENABLED) {
                            CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Found existing unowned collection instance [%s] in Session; skipping processing - [%s]", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
                        }
                        return;
                    }
                    this.takeResponsibility(rowProcessingState, this.collectionKey);
                }
            }
        }
        if (this.collectionInstance == null && this.collectionKey != null) {
            CollectionPersister collectionDescriptor = this.getCollectionAttributeMapping().getCollectionDescriptor();
            CollectionSemantics<?, ?> collectionSemantics = collectionDescriptor.getCollectionSemantics();
            this.collectionInstance = collectionSemantics.instantiateWrapper(this.collectionKey.getKey(), this.getInitializingCollectionDescriptor(), session);
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Created new collection wrapper [%s] : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
            }
            persistenceContext.addUninitializedCollection(collectionDescriptor, this.collectionInstance, this.collectionKey.getKey());
            this.takeResponsibility(rowProcessingState, this.collectionKey);
        }
        if (this.responsibility != null) {
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Responsible for loading collection [%s] : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
            }
            if (this.getParentAccess() != null) {
                this.getParentAccess().registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
            }
        }
    }

    private String toLoggableString(PersistentCollection<?> collectionInstance) {
        return collectionInstance == null ? "<null>" : collectionInstance.getClass().getName() + "@" + System.identityHashCode(collectionInstance);
    }

    protected void takeResponsibility(RowProcessingState rowProcessingState, CollectionKey collectionKey) {
        this.responsibility = new LoadingCollectionEntryImpl(this.getCollectionAttributeMapping().getCollectionDescriptor(), this, collectionKey.getKey(), this.collectionInstance);
        rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingCollection(collectionKey, this.responsibility);
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.collectionKey != null) {
            return;
        }
        super.resolveKey(rowProcessingState);
        this.collectionValueKey = this.collectionValueKeyResultAssembler == null ? this.collectionKey.getKey() : this.collectionValueKeyResultAssembler.assemble(rowProcessingState);
    }

    protected Object getCollectionValueKey() {
        return this.collectionValueKey;
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (this.responsibility == null || this.isInitialized) {
            return;
        }
        CollectionKey collectionKey = this.resolveCollectionKey(rowProcessingState);
        Object collectionValueKey = this.getCollectionValueKey();
        if (collectionValueKey != null) {
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Reading element from row for collection [%s] -> %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
            }
            this.responsibility.load(loadingState -> this.readCollectionRow(collectionKey, (List<Object>)loadingState, rowProcessingState));
        }
        this.isInitialized = true;
    }

    protected abstract void readCollectionRow(CollectionKey var1, List<Object> var2, RowProcessingState var3);

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        super.finishUpRow(rowProcessingState);
        this.collectionValueKey = null;
        this.collectionInstance = null;
        this.responsibility = null;
        this.isInitialized = false;
    }
}

