/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class BagInitializer
extends AbstractImmediateCollectionInitializer {
    private static final String CONCRETE_NAME = BagInitializer.class.getSimpleName();
    private final DomainResultAssembler<?> elementAssembler;
    private final DomainResultAssembler<?> collectionIdAssembler;

    public BagInitializer(PluralAttributeMapping bagDescriptor, FetchParentAccess parentAccess, NavigablePath navigablePath, LockMode lockMode, DomainResultAssembler<?> collectionKeyAssembler, DomainResultAssembler<?> collectionValueKeyAssembler, DomainResultAssembler<?> elementAssembler, DomainResultAssembler<?> collectionIdAssembler) {
        super(navigablePath, bagDescriptor, parentAccess, lockMode, collectionKeyAssembler, collectionValueKeyAssembler);
        this.elementAssembler = elementAssembler;
        this.collectionIdAssembler = collectionIdAssembler;
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    @Override
    protected void readCollectionRow(CollectionKey collectionKey, List<Object> loadingState, RowProcessingState rowProcessingState) {
        if (this.collectionIdAssembler != null) {
            Object[] row = new Object[]{this.collectionIdAssembler.assemble(rowProcessingState), this.elementAssembler.assemble(rowProcessingState)};
            loadingState.add(row);
        } else {
            loadingState.add(this.elementAssembler.assemble(rowProcessingState));
        }
    }

    public String toString() {
        return "BagInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

