/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentMap;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class MapInitializer
extends AbstractImmediateCollectionInitializer {
    private static final String CONCRETE_NAME = MapInitializer.class.getSimpleName();
    private final DomainResultAssembler<?> mapKeyAssembler;
    private final DomainResultAssembler<?> mapValueAssembler;

    public MapInitializer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParentAccess parentAccess, LockMode lockMode, DomainResultAssembler<?> collectionKeyAssembler, DomainResultAssembler<?> collectionValueKeyAssembler, DomainResultAssembler<?> mapKeyAssembler, DomainResultAssembler<?> mapValueAssembler) {
        super(navigablePath, attributeMapping, parentAccess, lockMode, collectionKeyAssembler, collectionValueKeyAssembler);
        this.mapKeyAssembler = mapKeyAssembler;
        this.mapValueAssembler = mapValueAssembler;
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    public PersistentMap<?, ?> getCollectionInstance() {
        return (PersistentMap)super.getCollectionInstance();
    }

    @Override
    protected void readCollectionRow(CollectionKey collectionKey, List<Object> loadingState, RowProcessingState rowProcessingState) {
        loadingState.add(new Object[]{this.mapKeyAssembler.assemble(rowProcessingState), this.mapValueAssembler.assemble(rowProcessingState)});
    }

    public String toString() {
        return "MapInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

