/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;

public abstract class AbstractNonLazyEntityFetch
extends AbstractFetchParent
implements EntityFetch {
    private final FetchParent fetchParent;
    private final boolean nullable;
    private final EntityValuedModelPart referencedModelPart;

    public AbstractNonLazyEntityFetch(FetchParent fetchParent, EntityValuedModelPart fetchedPart, NavigablePath navigablePath, boolean nullable) {
        super(fetchedPart.getEntityMappingType(), navigablePath);
        this.referencedModelPart = fetchedPart;
        this.fetchParent = fetchParent;
        this.nullable = nullable;
    }

    @Override
    public EntityMappingType getReferencedMappingType() {
        return this.getEntityValuedModelPart().getEntityMappingType();
    }

    @Override
    public EntityMappingType getReferencedMappingContainer() {
        return this.getEntityValuedModelPart().getEntityMappingType();
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public Fetchable getFetchedMapping() {
        return (Fetchable)((Object)this.getEntityValuedModelPart());
    }

    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        EntityInitializer entityInitializer = this.getEntityInitializer(parentAccess, creationState);
        return new EntityAssembler(this.getFetchedMapping().getJavaType(), entityInitializer);
    }

    protected abstract EntityInitializer getEntityInitializer(FetchParentAccess var1, AssemblerCreationState var2);

    @Override
    public EntityValuedModelPart getEntityValuedModelPart() {
        return this.referencedModelPart;
    }
}

