/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain;

import java.util.function.BiConsumer;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.BiDirectionalFetch;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntitySelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchByUniqueKeyInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class CircularFetchImpl
implements BiDirectionalFetch,
Association {
    private final DomainResult<?> keyResult;
    private final EntityValuedModelPart referencedModelPart;
    private final EntityMappingType entityMappingType;
    private final FetchTiming timing;
    private final NavigablePath navigablePath;
    private final ToOneAttributeMapping fetchable;
    private final boolean selectByUniqueKey;
    private final FetchParent fetchParent;
    private final NavigablePath referencedNavigablePath;

    public CircularFetchImpl(EntityValuedModelPart referencedModelPart, EntityMappingType entityMappingType, FetchTiming timing, NavigablePath navigablePath, FetchParent fetchParent, ToOneAttributeMapping fetchable, boolean selectByUniqueKey, NavigablePath referencedNavigablePath, DomainResult<?> keyResult) {
        this.referencedModelPart = referencedModelPart;
        this.entityMappingType = entityMappingType;
        this.timing = timing;
        this.fetchParent = fetchParent;
        this.navigablePath = navigablePath;
        this.selectByUniqueKey = selectByUniqueKey;
        this.referencedNavigablePath = referencedNavigablePath;
        this.fetchable = fetchable;
        this.keyResult = keyResult;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public NavigablePath getReferencedPath() {
        return this.referencedNavigablePath;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public Fetchable getFetchedMapping() {
        return this.fetchable;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.fetchable.getJavaType();
    }

    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        DomainResultAssembler<?> resultAssembler = this.keyResult.createResultAssembler(parentAccess, creationState);
        EntityInitializer initializer = (EntityInitializer)creationState.resolveInitializer(this.getNavigablePath(), this.referencedModelPart, () -> {
            if (this.timing == FetchTiming.IMMEDIATE) {
                if (this.selectByUniqueKey) {
                    return new EntitySelectFetchByUniqueKeyInitializer(parentAccess, this.fetchable, this.getNavigablePath(), this.entityMappingType.getEntityPersister(), resultAssembler);
                }
                EntityPersister entityPersister = this.entityMappingType.getEntityPersister();
                if (entityPersister.isBatchLoadable()) {
                    return new BatchEntitySelectFetchInitializer(parentAccess, (ToOneAttributeMapping)this.referencedModelPart, this.getReferencedPath(), entityPersister, resultAssembler);
                }
                return new EntitySelectFetchInitializer(parentAccess, (ToOneAttributeMapping)this.referencedModelPart, this.getReferencedPath(), entityPersister, resultAssembler);
            }
            return new EntityDelayedFetchInitializer(parentAccess, this.getReferencedPath(), this.fetchable, this.selectByUniqueKey, resultAssembler);
        });
        return new BiDirectionalFetchAssembler(initializer, this.fetchable.getJavaType());
    }

    @Override
    public FetchTiming getTiming() {
        return this.timing;
    }

    @Override
    public boolean hasTableGroup() {
        return true;
    }

    @Override
    public String getFetchableName() {
        return this.fetchable.getFetchableName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPartName() {
        return this.fetchable.getFetchableName();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.fetchable.getNavigableRole();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.fetchable.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.fetchable.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.fetchable.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.fetchable.findContainingEntityMapping();
    }

    @Override
    public MappingType getPartMappingType() {
        return this.fetchable.getPartMappingType();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.fetchable.getJavaType();
    }

    @Override
    public ForeignKeyDescriptor getForeignKeyDescriptor() {
        return ((Association)((Object)this.fetchParent)).getForeignKeyDescriptor();
    }

    @Override
    public ForeignKeyDescriptor.Nature getSideNature() {
        return ((Association)((Object)this.fetchParent)).getSideNature();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.fetchable.breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        throw new UnsupportedOperationException();
    }

    private static class BiDirectionalFetchAssembler
    implements DomainResultAssembler {
        private EntityInitializer initializer;
        private JavaType assembledJavaType;

        public BiDirectionalFetchAssembler(EntityInitializer initializer, JavaType assembledJavaType) {
            this.initializer = initializer;
            this.assembledJavaType = assembledJavaType;
        }

        public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            this.initializer.resolveInstance(rowProcessingState);
            return this.initializer.getInitializedInstance();
        }

        public JavaType getAssembledJavaType() {
            return this.assembledJavaType;
        }
    }
}

