/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.caching.QueryCachePutManager;
import org.hibernate.sql.results.caching.internal.QueryCachePutManagerDisabledImpl;
import org.hibernate.sql.results.caching.internal.QueryCachePutManagerEnabledImpl;
import org.hibernate.sql.results.jdbc.internal.AbstractJdbcValues;
import org.hibernate.sql.results.jdbc.internal.ResultSetAccess;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.WrapperOptions;

public class JdbcValuesResultSetImpl
extends AbstractJdbcValues {
    private final ResultSetAccess resultSetAccess;
    private final JdbcValuesMapping valuesMapping;
    private final ExecutionContext executionContext;
    private final SqlSelection[] sqlSelections;
    private final Object[] currentRowJdbcValues;

    public JdbcValuesResultSetImpl(ResultSetAccess resultSetAccess, QueryKey queryCacheKey, String queryIdentifier, QueryOptions queryOptions, JdbcValuesMapping valuesMapping, JdbcValuesMetadata metadataForCache, ExecutionContext executionContext) {
        super(JdbcValuesResultSetImpl.resolveQueryCachePutManager(executionContext, queryOptions, queryCacheKey, queryIdentifier, metadataForCache));
        this.resultSetAccess = resultSetAccess;
        this.valuesMapping = valuesMapping;
        this.executionContext = executionContext;
        this.sqlSelections = valuesMapping.getSqlSelections().toArray(new SqlSelection[0]);
        this.currentRowJdbcValues = new Object[valuesMapping.getRowSize()];
    }

    private static QueryCachePutManager resolveQueryCachePutManager(ExecutionContext executionContext, QueryOptions queryOptions, QueryKey queryCacheKey, String queryIdentifier, JdbcValuesMetadata metadataForCache) {
        if (queryCacheKey != null) {
            SessionFactoryImplementor factory = executionContext.getSession().getFactory();
            QueryResultsCache queryCache = factory.getCache().getQueryResultsCache(queryOptions.getResultCacheRegionName());
            return new QueryCachePutManagerEnabledImpl(queryCache, factory.getStatistics(), queryCacheKey, queryIdentifier, metadataForCache);
        }
        return QueryCachePutManagerDisabledImpl.INSTANCE;
    }

    @Override
    protected final boolean processNext(RowProcessingState rowProcessingState) {
        return this.advance(() -> {
            try {
                return this.resultSetAccess.getResultSet().next();
            }
            catch (SQLException e) {
                throw this.makeExecutionException("Error advancing (next) ResultSet position", e);
            }
        });
    }

    @Override
    protected boolean processPrevious(RowProcessingState rowProcessingState) {
        return this.advance(() -> {
            try {
                return this.resultSetAccess.getResultSet().previous();
            }
            catch (SQLException e) {
                throw this.makeExecutionException("Error advancing (previous) ResultSet position", e);
            }
        });
    }

    @Override
    protected boolean processScroll(int numberOfRows, RowProcessingState rowProcessingState) {
        return this.advance(() -> {
            try {
                return this.resultSetAccess.getResultSet().relative(numberOfRows);
            }
            catch (SQLException e) {
                throw this.makeExecutionException("Error advancing (scroll) ResultSet position", e);
            }
        });
    }

    @Override
    public int getPosition() {
        try {
            return this.resultSetAccess.getResultSet().getRow() - 1;
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#getRow", e);
        }
    }

    @Override
    protected boolean processPosition(int position, RowProcessingState rowProcessingState) {
        return this.advance(() -> {
            try {
                return this.resultSetAccess.getResultSet().absolute(position);
            }
            catch (SQLException e) {
                throw this.makeExecutionException("Error advancing (scroll) ResultSet position", e);
            }
        });
    }

    @Override
    public boolean isBeforeFirst(RowProcessingState rowProcessingState) {
        try {
            return this.resultSetAccess.getResultSet().isBeforeFirst();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#isBeforeFirst()", e);
        }
    }

    @Override
    public void beforeFirst(RowProcessingState rowProcessingState) {
        try {
            this.resultSetAccess.getResultSet().beforeFirst();
            Arrays.fill(this.currentRowJdbcValues, null);
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#beforeFirst()", e);
        }
    }

    @Override
    public boolean isFirst(RowProcessingState rowProcessingState) {
        try {
            return this.resultSetAccess.getResultSet().isFirst();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#isFirst()", e);
        }
    }

    @Override
    public boolean first(RowProcessingState rowProcessingState) {
        return this.advance(() -> {
            try {
                return this.resultSetAccess.getResultSet().first();
            }
            catch (SQLException e) {
                throw this.makeExecutionException("Error advancing (first) ResultSet position", e);
            }
        });
    }

    @Override
    public boolean isAfterLast(RowProcessingState rowProcessingState) {
        try {
            return this.resultSetAccess.getResultSet().isAfterLast();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#isAfterLast()", e);
        }
    }

    @Override
    public void afterLast(RowProcessingState rowProcessingState) {
        try {
            this.resultSetAccess.getResultSet().afterLast();
            Arrays.fill(this.currentRowJdbcValues, null);
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#afterLast()", e);
        }
    }

    @Override
    public boolean isLast(RowProcessingState rowProcessingState) {
        try {
            return this.resultSetAccess.getResultSet().isLast();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#isLast()", e);
        }
    }

    @Override
    public boolean last(RowProcessingState rowProcessingState) {
        return this.advance(() -> {
            try {
                return this.resultSetAccess.getResultSet().last();
            }
            catch (SQLException e) {
                throw this.makeExecutionException("Error advancing (last) ResultSet position", e);
            }
        });
    }

    private boolean advance(Advancer advancer) {
        boolean hasResult = advancer.advance();
        if (!hasResult) {
            return false;
        }
        this.readCurrentRowValues();
        return true;
    }

    private ExecutionException makeExecutionException(String message, SQLException cause) {
        return new ExecutionException(message, this.executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert(cause, message));
    }

    private void readCurrentRowValues() {
        ResultSet resultSet = this.resultSetAccess.getResultSet();
        SharedSessionContractImplementor session = this.executionContext.getSession();
        for (SqlSelection sqlSelection : this.sqlSelections) {
            try {
                this.currentRowJdbcValues[sqlSelection.getValuesArrayPosition()] = sqlSelection.getJdbcValueExtractor().extract(resultSet, sqlSelection.getJdbcResultSetIndex(), (WrapperOptions)session);
            }
            catch (Exception e) {
                throw new HibernateException("Unable to extract JDBC value for position `" + sqlSelection.getJdbcResultSetIndex() + "`", e);
            }
        }
    }

    @Override
    protected void release() {
        this.resultSetAccess.release();
    }

    @Override
    public JdbcValuesMapping getValuesMapping() {
        return this.valuesMapping;
    }

    @Override
    public Object[] getCurrentRowValuesArray() {
        return this.currentRowJdbcValues;
    }

    @FunctionalInterface
    private static interface Advancer {
        public boolean advance();
    }
}

