/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.type.descriptor.java.JavaType;

public class ListResultsConsumer<R>
implements ResultsConsumer<List<R>, R> {
    private static final ListResultsConsumer UNIQUE_FILTER_INSTANCE = new ListResultsConsumer(UniqueSemantic.FILTER);
    private static final ListResultsConsumer NORMAL_INSTANCE = new ListResultsConsumer(UniqueSemantic.NONE);
    private static final ListResultsConsumer UNIQUE_INSTANCE = new ListResultsConsumer(UniqueSemantic.ASSERT);
    private final UniqueSemantic uniqueSemantic;

    public static <R> ListResultsConsumer<R> instance(UniqueSemantic uniqueSemantic) {
        switch (uniqueSemantic) {
            case ASSERT: {
                return UNIQUE_INSTANCE;
            }
            case FILTER: {
                return UNIQUE_FILTER_INSTANCE;
            }
        }
        return NORMAL_INSTANCE;
    }

    public ListResultsConsumer(UniqueSemantic uniqueSemantic) {
        this.uniqueSemantic = uniqueSemantic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<R> consume(JdbcValues jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader) {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        RuntimeException ex = null;
        try {
            EntityPersister entityDescriptor;
            Class<R> resultJavaType;
            persistenceContext.getLoadContexts().register(jdbcValuesSourceProcessingState);
            ArrayList<R> results = new ArrayList<R>();
            boolean uniqueRows = false;
            if (this.uniqueSemantic != UniqueSemantic.NONE && (resultJavaType = rowReader.getResultJavaType()) != null && !resultJavaType.isArray() && (entityDescriptor = session.getFactory().getRuntimeMetamodels().getMappingMetamodel().findEntityDescriptor(resultJavaType)) != null) {
                uniqueRows = true;
            }
            if (!uniqueRows) {
                while (rowProcessingState.next()) {
                    results.add(rowReader.readRow(rowProcessingState, processingOptions));
                    rowProcessingState.finishRowProcessing();
                }
            } else {
                List<JavaType> resultJavaTypes = rowReader.getResultJavaTypes();
                assert (resultJavaTypes.size() == 1);
                JavaType resultJavaType2 = resultJavaTypes.get(0);
                while (rowProcessingState.next()) {
                    R row = rowReader.readRow(rowProcessingState, processingOptions);
                    boolean add = true;
                    for (Object existingRow : results) {
                        if (!resultJavaType2.areEqual(existingRow, row)) continue;
                        if (this.uniqueSemantic == UniqueSemantic.ASSERT && !rowProcessingState.hasCollectionInitializers()) {
                            throw new HibernateException("More than one row with the given identifier was found: " + jdbcValuesSourceProcessingState.getExecutionContext().getEntityId() + ", for class: " + rowReader.getResultJavaType().getName());
                        }
                        add = false;
                        break;
                    }
                    if (add) {
                        results.add(row);
                    }
                    rowProcessingState.finishRowProcessing();
                }
            }
            try {
                jdbcValuesSourceProcessingState.finishUp();
            }
            finally {
                persistenceContext.getLoadContexts().deregister(jdbcValuesSourceProcessingState);
            }
            ArrayList<R> arrayList = results;
            return arrayList;
        }
        catch (RuntimeException e) {
            ex = e;
            return ex;
        }
        finally {
            try {
                rowReader.finishUp(jdbcValuesSourceProcessingState);
                jdbcValues.finishUp(session);
                persistenceContext.initializeNonLazyCollections();
            }
            catch (RuntimeException e) {
                if (ex != null) {
                    ex.addSuppressed(e);
                }
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) throw new IllegalStateException("Should not reach this!");
                throw ex;
            }
        }
    }

    @Override
    public boolean canResultsBeCached() {
        return true;
    }

    public static enum UniqueSemantic {
        NONE,
        FILTER,
        ASSERT;

    }
}

