/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public abstract class AbstractJavaType<T>
implements BasicJavaType<T>,
Serializable {
    private final Type type;
    private final MutabilityPlan<T> mutabilityPlan;
    private final Comparator<T> comparator;

    protected AbstractJavaType(Type type) {
        this(type, ImmutableMutabilityPlan.INSTANCE);
    }

    protected AbstractJavaType(Type type, MutabilityPlan<T> mutabilityPlan) {
        this.type = type;
        this.mutabilityPlan = mutabilityPlan;
        this.comparator = Comparable.class.isAssignableFrom(this.getJavaTypeClass()) ? ComparableComparator.INSTANCE : null;
    }

    @Override
    public MutabilityPlan<T> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public Type getJavaType() {
        return this.type;
    }

    @Override
    public int extractHashCode(T value) {
        return value.hashCode();
    }

    @Override
    public boolean areEqual(T one, T another) {
        return Objects.equals(one, another);
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public String extractLoggableRepresentation(T value) {
        return value == null ? "null" : value.toString();
    }

    protected HibernateException unknownUnwrap(Class conversionType) {
        throw new HibernateException("Unknown unwrap conversion requested: " + this.type.getTypeName() + " to " + conversionType.getName());
    }

    protected HibernateException unknownWrap(Class conversionType) {
        throw new HibernateException("Unknown wrap conversion requested: " + conversionType.getName() + " to " + this.type.getTypeName());
    }
}

