/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.BiConsumer;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.usertype.UserType;

public abstract class BaseUserTypeSupport<T>
implements UserType<T> {
    private BasicJavaType<T> javaType;
    private JdbcType jdbcType;
    private boolean resolved;
    private int[] sqlTypes;
    private ValueExtractor<T> jdbcValueExtractor;
    private ValueBinder<T> jdbcValueBinder;

    protected abstract void resolve(BiConsumer<BasicJavaType<T>, JdbcType> var1);

    private void ensureResolved() {
        if (this.resolved) {
            return;
        }
        this.resolve((javaType, jdbcType) -> {
            this.javaType = javaType;
            this.jdbcType = jdbcType;
            this.sqlTypes = new int[]{jdbcType.getJdbcTypeCode()};
            this.jdbcValueExtractor = jdbcType.getExtractor(javaType);
            this.jdbcValueBinder = jdbcType.getBinder(javaType);
            this.resolved = true;
        });
    }

    protected JdbcType jdbcType() {
        this.ensureResolved();
        return this.jdbcType;
    }

    protected BasicJavaType<T> javaType() {
        this.ensureResolved();
        return this.javaType;
    }

    @Override
    public int[] sqlTypes() {
        this.ensureResolved();
        return this.sqlTypes;
    }

    @Override
    public Class<T> returnedClass() {
        return this.javaType().getJavaTypeClass();
    }

    @Override
    public boolean equals(Object x, Object y) throws HibernateException {
        return this.javaType().areEqual(x, y);
    }

    @Override
    public int hashCode(Object x) throws HibernateException {
        return this.javaType().extractHashCode(x);
    }

    @Override
    public T nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        this.ensureResolved();
        return this.jdbcValueExtractor.extract(rs, position, (WrapperOptions)session);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, T value, int index, SharedSessionContractImplementor session) throws SQLException {
        this.ensureResolved();
        this.jdbcValueBinder.bind(st, value, index, (WrapperOptions)session);
    }

    @Override
    public Object deepCopy(Object value) throws HibernateException {
        return this.javaType().getMutabilityPlan().deepCopy(value);
    }

    @Override
    public boolean isMutable() {
        return this.javaType().getMutabilityPlan().isMutable();
    }

    @Override
    public Serializable disassemble(Object value) throws HibernateException {
        return this.javaType().getMutabilityPlan().disassemble(value, null);
    }

    @Override
    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.javaType().getMutabilityPlan().assemble(cached, null);
    }

    @Override
    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }
}

