/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.usertype;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.usertype.UserType;

public class StaticUserTypeSupport<T>
implements UserType<T> {
    private final BasicJavaType javaType;
    private final JdbcType jdbcType;
    private final MutabilityPlan mutabilityPlan;
    private final BasicValueConverter valueConverter;
    private final int[] sqlTypes;
    private ValueExtractor jdbcValueExtractor;
    private ValueBinder jdbcValueBinder;

    public StaticUserTypeSupport(BasicJavaType javaType, JdbcType jdbcType) {
        this(javaType, jdbcType, javaType.getMutabilityPlan());
    }

    public StaticUserTypeSupport(BasicJavaType javaType, JdbcType jdbcType, MutabilityPlan mutabilityPlan) {
        this(javaType, jdbcType, mutabilityPlan, null);
    }

    public StaticUserTypeSupport(BasicJavaType javaType, JdbcType jdbcType, BasicValueConverter valueConverter) {
        this(javaType, jdbcType, javaType.getMutabilityPlan(), valueConverter);
    }

    public StaticUserTypeSupport(BasicJavaType javaType, JdbcType jdbcType, MutabilityPlan mutabilityPlan, BasicValueConverter valueConverter) {
        this.javaType = javaType;
        this.jdbcType = jdbcType;
        this.mutabilityPlan = mutabilityPlan;
        this.valueConverter = valueConverter;
        this.sqlTypes = new int[]{jdbcType.getJdbcTypeCode()};
        this.jdbcValueExtractor = jdbcType.getExtractor(javaType);
        this.jdbcValueBinder = jdbcType.getBinder(javaType);
    }

    public BasicJavaType getJavaType() {
        return this.javaType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public MutabilityPlan getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    public BasicValueConverter getValueConverter() {
        return this.valueConverter;
    }

    public ValueExtractor getJdbcValueExtractor() {
        return this.jdbcValueExtractor;
    }

    public ValueBinder getJdbcValueBinder() {
        return this.jdbcValueBinder;
    }

    @Override
    public int[] sqlTypes() {
        return this.sqlTypes;
    }

    @Override
    public Class<T> returnedClass() {
        return this.javaType.getJavaTypeClass();
    }

    @Override
    public boolean equals(Object x, Object y) throws HibernateException {
        return this.javaType.areEqual(x, y);
    }

    @Override
    public int hashCode(Object x) throws HibernateException {
        return this.javaType.extractHashCode(x);
    }

    @Override
    public T nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        Object extracted = this.jdbcValueExtractor.extract(rs, position, (WrapperOptions)session);
        if (this.valueConverter != null) {
            return (T)this.valueConverter.toDomainValue(extracted);
        }
        return (T)extracted;
    }

    @Override
    public void nullSafeSet(PreparedStatement st, T value, int index, SharedSessionContractImplementor session) throws SQLException {
        Object valueToBind = this.valueConverter != null ? this.valueConverter.toRelationalValue(value) : value;
        this.jdbcValueBinder.bind(st, valueToBind, index, (WrapperOptions)session);
    }

    @Override
    public Object deepCopy(Object value) throws HibernateException {
        return this.javaType.getMutabilityPlan().deepCopy(value);
    }

    @Override
    public boolean isMutable() {
        return this.javaType.getMutabilityPlan().isMutable();
    }

    @Override
    public Serializable disassemble(Object value) throws HibernateException {
        return this.javaType.getMutabilityPlan().disassemble(value, null);
    }

    @Override
    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.javaType.getMutabilityPlan().assemble(cached, null);
    }

    @Override
    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }
}

