/*
 * Decompiled with CFR 0.152.
 */
package persistance;

import common.MainOrderDto;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import persistance.HibernateSessionUtil;
import persistance.entities.Effort;
import persistance.entities.MainOrder;
import persistance.entities.OrderCategory;
import persistance.entities.OrderStatus;
import persistance.entities.ProjectTimeTrackerEntityInf;
import persistance.entities.SubOrder;
import persistance.queryresults.GroupedEffort;
import util.DateAndTimeHelper;

public class EntityDao {
    private Session session = HibernateSessionUtil.getSessionFactory().openSession();

    public ProjectTimeTrackerEntityInf insertEntity(ProjectTimeTrackerEntityInf entity) {
        this.session.beginTransaction();
        this.session.persist(entity);
        this.session.flush();
        this.session.clear();
        this.session.refresh(entity);
        this.session.getTransaction().commit();
        return entity;
    }

    public void updateEntity(ProjectTimeTrackerEntityInf entity) {
        this.session.beginTransaction();
        this.session.merge(entity);
        this.session.flush();
        this.session.clear();
        this.session.refresh(entity);
        this.session.getTransaction().commit();
    }

    public List<MainOrder> getMainOrders(boolean onlyVisible) {
        return this.getMainOrdersByName(null, onlyVisible);
    }

    public MainOrder getMainOrderById(Integer mainOrderId) {
        HibernateCriteriaBuilder cb = this.session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(MainOrder.class);
        Root<MainOrder> root = cr.from(MainOrder.class);
        cr.select(root).where((Expression)cb.equal((Expression)root.get("id"), (Object)mainOrderId));
        TypedQuery query = this.session.createQuery(cr);
        return (MainOrder)query.getSingleResult();
    }

    public SubOrder getSubOrderById(Integer subOrderId) {
        HibernateCriteriaBuilder cb = this.session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(SubOrder.class);
        Root<SubOrder> root = cr.from(SubOrder.class);
        cr.select(root).where((Expression)cb.equal((Expression)root.get("id"), (Object)subOrderId));
        TypedQuery query = this.session.createQuery(cr);
        return (SubOrder)query.getSingleResult();
    }

    public List<MainOrder> getMainOrdersByName(String orderName, boolean onlyVisible) {
        HibernateCriteriaBuilder cb = this.session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(MainOrder.class);
        Root<MainOrder> root = cr.from(MainOrder.class);
        ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
        if (orderName != null) {
            predicateList.add(cb.ilike(root.get("mainOrderName"), "%" + orderName + "%"));
        }
        if (onlyVisible) {
            predicateList.add(cb.isTrue((Expression)root.get("visible")));
        }
        if (!predicateList.isEmpty()) {
            cr.select(root).where((Predicate[])predicateList.toArray(Predicate[]::new));
        } else {
            cr.select(root);
        }
        cr.orderBy(cb.asc((Expression)root.get("mainOrderNumber")), cb.asc((Expression)root.get("mainOrderName")));
        TypedQuery query = this.session.createQuery(cr);
        return query.getResultList();
    }

    public void deleteEntity(Object entity) {
        this.session.beginTransaction();
        this.session.remove(entity);
        this.session.getTransaction().commit();
    }

    public void deleteEntity(Class<? extends ProjectTimeTrackerEntityInf> entityClass, Integer id) {
        ProjectTimeTrackerEntityInf entityToBeDeleted = this.session.find(entityClass, id);
        this.deleteEntity(entityToBeDeleted);
    }

    public List<OrderCategory> getCategories() {
        HibernateCriteriaBuilder cb = this.session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(OrderCategory.class);
        Root<OrderCategory> root = cr.from(OrderCategory.class);
        cr.select(root);
        TypedQuery query = this.session.createQuery(cr);
        return query.getResultList();
    }

    public OrderCategory getCategory(String categoryName) {
        HibernateCriteriaBuilder cb = this.session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(OrderCategory.class);
        Root<OrderCategory> root = cr.from(OrderCategory.class);
        cr.select(root).where((Expression)cb.like((Expression)root.get("categoryName"), categoryName));
        TypedQuery query = this.session.createQuery(cr);
        return (OrderCategory)query.getSingleResult();
    }

    public OrderStatus getStatusByName(String statusName) {
        HibernateCriteriaBuilder cb = this.session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(OrderStatus.class);
        Root<OrderStatus> root = cr.from(OrderStatus.class);
        cr.select(root).where((Expression)cb.equal((Expression)root.get("statusName"), (Object)statusName));
        TypedQuery query = this.session.createQuery(cr);
        return (OrderStatus)query.getSingleResult();
    }

    public List<OrderStatus> getStatuses() {
        HibernateCriteriaBuilder cb = this.session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(OrderStatus.class);
        Root<OrderStatus> root = cr.from(OrderStatus.class);
        cr.select(root);
        TypedQuery query = this.session.createQuery(cr);
        return query.getResultList();
    }

    public List<SubOrder> getSubOrders(MainOrderDto mainOrderDto) {
        return this.getSubOrders(mainOrderDto, false);
    }

    public List<SubOrder> getSubOrders(MainOrderDto mainOrderDto, boolean onlyVisible) {
        HibernateCriteriaBuilder cb = this.session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(SubOrder.class);
        Root<SubOrder> root = cr.from(SubOrder.class);
        ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
        predicateList.add(cb.equal((Expression)root.get("mainOrder").get("id"), (Object)mainOrderDto.getId()));
        if (onlyVisible) {
            predicateList.add(cb.isTrue((Expression)root.get("visible")));
        }
        cr.select(root).where((Predicate[])predicateList.toArray(Predicate[]::new));
        TypedQuery query = this.session.createQuery(cr);
        return query.getResultList();
    }

    public List<Effort> getEffortByDay(LocalDate date) {
        HibernateCriteriaBuilder cb = this.session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(Effort.class);
        Root<Effort> root = cr.from(Effort.class);
        cr.select(root).where((Expression)cb.equal((Expression)root.get("effortDate"), (Object)date));
        TypedQuery query = this.session.createQuery(cr);
        return query.getResultList();
    }

    public List<GroupedEffort> getGroupedEffortByDate(LocalDate startDate, LocalDate endDate, String categoryName, String statusName) {
        HibernateCriteriaBuilder cb = this.session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(Object[].class);
        Root<Effort> root = cr.from(Effort.class);
        ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
        predicateList.add(cb.between((Expression)root.get("effortDate"), startDate, endDate));
        if (statusName != null) {
            predicateList.add(cb.equal((Expression)root.get("status").get("statusName"), (Object)statusName));
        }
        if (categoryName != null) {
            predicateList.add(cb.equal((Expression)root.get("mainOrder").get("category").get("categoryName"), (Object)categoryName));
        }
        cr.multiselect(cb.sum((Expression)root.get("duration")), root.get("mainOrder"), root.join("subOrder", JoinType.LEFT), root.join("status", JoinType.LEFT));
        cr.where((Predicate[])predicateList.toArray(Predicate[]::new));
        cr.groupBy(new Expression[]{root.get("mainOrder"), root.get("subOrder"), root.get("status")});
        TypedQuery query = this.session.createQuery(cr);
        List queryResults = query.getResultList();
        ArrayList<GroupedEffort> groupedResults = new ArrayList<GroupedEffort>();
        for (Object[] object : queryResults) {
            groupedResults.add(new GroupedEffort(object, startDate, endDate));
        }
        return groupedResults;
    }

    public LocalTime getTotalTime(LocalDate date) {
        List<Effort> effortList = this.getEffortByDay(date);
        Long totalTime = 0L;
        for (Effort effort : effortList) {
            totalTime = totalTime + (long)effort.getDuration().intValue();
        }
        return DateAndTimeHelper.getLocalTimeMM(String.valueOf(totalTime));
    }

    public Effort getEffortById(int effortId) {
        HibernateCriteriaBuilder cb = this.session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(Effort.class);
        Root<Effort> root = cr.from(Effort.class);
        cr.select(root).where((Expression)cb.equal((Expression)root.get("id"), (Object)effortId));
        TypedQuery query = this.session.createQuery(cr);
        return (Effort)query.getSingleResult();
    }

    public List<Effort> getEfforts(GroupedEffort groupedEffort) {
        HibernateCriteriaBuilder cb = this.session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(Effort.class);
        Root<Effort> root = cr.from(Effort.class);
        ArrayList<Predicate> predicateList = new ArrayList<Predicate>();
        predicateList.add(cb.between((Expression)root.get("effortDate"), groupedEffort.getStartDate(), groupedEffort.getEndDate()));
        predicateList.add(cb.equal((Expression)root.get("mainOrder"), (Object)groupedEffort.getMainOrder()));
        if (groupedEffort.getSubOrder() != null) {
            predicateList.add(cb.equal((Expression)root.get("subOrder"), (Object)groupedEffort.getSubOrder()));
        } else {
            predicateList.add(cb.isNull((Expression)root.get("subOrder")));
        }
        if (groupedEffort.getStatus() != null) {
            predicateList.add(cb.equal((Expression)root.get("status"), (Object)groupedEffort.getStatus()));
        }
        cr.select(root).where((Predicate[])predicateList.toArray(Predicate[]::new));
        TypedQuery query = this.session.createQuery(cr);
        return query.getResultList();
    }
}

