/*
 * Decompiled with CFR 0.152.
 */
package persistance.entities;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import org.hibernate.annotations.Formula;
import persistance.PropertyNotSetException;
import persistance.entities.MainOrder;
import persistance.entities.OrderStatus;
import persistance.entities.ProjectTimeTrackerEntityInf;
import persistance.entities.SubOrder;
import util.DateAndTimeHelper;

@Entity
@Table(name="efforts")
public class Effort
implements ProjectTimeTrackerEntityInf {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(unique=true, nullable=false)
    private Integer id;
    @Column(nullable=false)
    private LocalDate effortDate;
    @Column(nullable=false)
    private LocalTime startTime;
    @Column(nullable=false)
    private LocalTime endTime;
    private LocalTime pauseTime;
    @Formula(value="CASE WHEN (datediff(Minute, dateadd(Minute, datediff(Minute, TIME '00:00:00', pausetime), starttime), endtime)) < 0 THEN ((datediff(Minute, dateadd(Minute, datediff(Minute, TIME '00:00:00', pausetime), starttime), endtime)) + 24*60) ELSE (datediff(Minute, dateadd(Minute, datediff(Minute, TIME '00:00:00', pausetime), starttime), endtime)) END")
    private Integer duration;
    @ManyToOne(optional=false)
    @JoinColumn(name="mainOrder_id")
    private MainOrder mainOrder;
    @ManyToOne(optional=true)
    @JoinColumn(name="subOrder_id")
    private SubOrder subOrder;
    @ManyToOne(optional=true)
    @JoinColumn(name="status_id")
    private OrderStatus status;
    private String comment;

    public Effort() {
    }

    public Effort(LocalDate day, LocalTime startTime, LocalTime endTime, LocalTime pauseTime, MainOrder mainOrder, SubOrder subOrder, OrderStatus status, String comment) {
        this.effortDate = day;
        this.startTime = startTime;
        this.endTime = endTime;
        this.pauseTime = pauseTime;
        this.mainOrder = mainOrder;
        this.subOrder = subOrder;
        this.status = status;
        this.comment = comment;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public LocalDate getEffortDate() {
        return this.effortDate;
    }

    public void setEffortDate(LocalDate effortDate) {
        this.effortDate = effortDate;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public LocalTime getPauseTime() {
        return this.pauseTime;
    }

    public void setPauseTime(LocalTime pauseTime) {
        this.pauseTime = pauseTime;
    }

    public MainOrder getMainOrder() {
        return this.mainOrder;
    }

    public void setMainOrder(MainOrder mainOrder) {
        this.mainOrder = mainOrder;
    }

    public SubOrder getSubOrder() {
        return this.subOrder;
    }

    public void setSubOrder(SubOrder subOrder) {
        this.subOrder = subOrder;
    }

    public OrderStatus getStatus() throws PropertyNotSetException {
        if (this.status != null) {
            return this.status;
        }
        throw new PropertyNotSetException("OrderStatus");
    }

    public void setStatus(OrderStatus status) {
        this.status = status;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getSignature() {
        return String.valueOf(this.effortDate.toString()) + this.startTime + this.endTime + this.pauseTime;
    }

    public String[] getTableRow() {
        String[] tableRow = new String[]{this.id.toString(), this.startTime.toString(), this.endTime.toString(), String.valueOf(this.pauseTime.get(ChronoField.MINUTE_OF_DAY)), DateAndTimeHelper.getLocalTimeMM(this.getDuration()).toString(), this.mainOrder.getMainOrderNumber(), this.mainOrder.getMainOrderName(), this.mainOrder.getCategory() == null ? "" : this.mainOrder.getCategory().getCategoryName(), this.subOrder == null ? "" : this.subOrder.getSubOrderNumber(), this.subOrder == null ? "" : this.subOrder.getSubOrderName(), this.status == null ? "" : this.status.toString(), this.comment};
        return tableRow;
    }

    public Integer getDuration() {
        return this.duration;
    }
}

