/*
 * Decompiled with CFR 0.152.
 */
package persistance.entities;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import persistance.entities.OrderCategory;
import persistance.entities.ProjectTimeTrackerEntityInf;

@Entity
@Table(name="mainorders", uniqueConstraints={@UniqueConstraint(columnNames={"mainOrderNumber", "mainOrderName"})})
public class MainOrder
implements Comparable<MainOrder>,
ProjectTimeTrackerEntityInf {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(unique=true, nullable=false)
    private Integer id;
    @Column(nullable=false)
    private String mainOrderNumber;
    @Column(nullable=false)
    private String mainOrderName;
    @ManyToOne
    @JoinColumn(name="orderCategory_id")
    private OrderCategory category;
    @Column(nullable=false)
    private Boolean visible;

    public MainOrder() {
    }

    public MainOrder(String mainOrderNumber, String mainOrderName, OrderCategory category, boolean visible) {
        this.mainOrderNumber = mainOrderNumber;
        this.mainOrderName = mainOrderName;
        this.category = category;
        this.visible = visible;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getMainOrderNumber() {
        return this.mainOrderNumber;
    }

    public void setMainOrderNumber(String mainOrderNumber) {
        this.mainOrderNumber = mainOrderNumber;
    }

    public String getMainOrderName() {
        return this.mainOrderName;
    }

    public void setMainOrderName(String mainOrderName) {
        this.mainOrderName = mainOrderName;
    }

    public OrderCategory getCategory() {
        return this.category;
    }

    public void setCategory(OrderCategory category) {
        this.category = category;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public String toString() {
        String objectString = String.valueOf(this.mainOrderNumber) + " | " + this.mainOrderName;
        if (!this.visible.booleanValue()) {
            objectString = String.valueOf(objectString) + " | " + "NOT VISIBLE";
        }
        return objectString;
    }

    @Override
    public int compareTo(MainOrder o) {
        return this.mainOrderNumber.compareTo(o.getMainOrderNumber());
    }

    @Override
    public String getSignature() {
        if (this.category != null) {
            return String.valueOf(this.mainOrderNumber) + this.mainOrderName + this.category.toString() + this.visible;
        }
        return String.valueOf(this.mainOrderNumber) + this.mainOrderName + this.visible;
    }
}

