/*
 * Decompiled with CFR 0.152.
 */
package persistance.queryresults;

import java.time.LocalDate;
import persistance.entities.MainOrder;
import persistance.entities.OrderStatus;
import persistance.entities.SubOrder;

public class GroupedEffort {
    LocalDate startDate;
    LocalDate endDate;
    private int summedTime;
    private MainOrder mainOrder;
    private SubOrder subOrder;
    private OrderStatus status;
    private static final int SUMMED_TIME_INDEX = 0;
    private static final int MAINORDER_INDEX = 1;
    private static final int SUBORDER_INDEX = 2;
    private static final int STATUS_INDEX = 3;

    public GroupedEffort(Object[] queryResult, LocalDate startDate, LocalDate endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.summedTime = (Integer)queryResult[0];
        this.mainOrder = (MainOrder)queryResult[1];
        this.subOrder = (SubOrder)queryResult[2];
        this.status = (OrderStatus)queryResult[3];
    }

    public GroupedEffort(LocalDate startDate, LocalDate endDate, int summedTime, MainOrder mainOrder, SubOrder subOrder, OrderStatus status) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.summedTime = summedTime;
        this.mainOrder = mainOrder;
        this.subOrder = subOrder;
        this.status = status;
    }

    public int getSummedTime() {
        return this.summedTime;
    }

    public MainOrder getMainOrder() {
        return this.mainOrder;
    }

    public SubOrder getSubOrder() {
        return this.subOrder;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }
}

