/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicArrowButton;
import org.jdatepicker.impl.DateComponentFormatter;
import org.jdatepicker.impl.JDatePanelImpl;
import org.jdatepicker.impl.JDatePickerImpl;
import org.jdatepicker.impl.UtilDateModel;

public class PttJDatePickerPanel {
    JPanel pickerPanel = new JPanel(new BorderLayout());
    UtilDateModel dateModel;
    JDatePickerImpl datePicker;
    BasicArrowButton dateUpButton;
    BasicArrowButton dateDownButton;

    public PttJDatePickerPanel() {
        this.createDateModelToday();
        this.createJDatePicker();
        this.createPickerPanel();
    }

    private void createPickerPanel() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.dateUpButton = new BasicArrowButton(1);
        buttonPanel.add((Component)this.dateUpButton, "North");
        this.addDayChangeListener(this.dateUpButton, -1);
        this.dateDownButton = new BasicArrowButton(5);
        buttonPanel.add((Component)this.dateDownButton, "South");
        this.addDayChangeListener(this.dateDownButton, 1);
        this.pickerPanel.add((Component)this.datePicker, "Center");
        this.pickerPanel.add((Component)buttonPanel, "East");
    }

    private void addDayChangeListener(BasicArrowButton arrowButton, final int daysToChange) {
        arrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PttJDatePickerPanel.this.datePicker.getModel().setDay(PttJDatePickerPanel.this.datePicker.getModel().getDay() + daysToChange);
                PttJDatePickerPanel.this.datePicker.getModel().setSelected(true);
            }
        });
    }

    private void createJDatePicker() {
        Properties p = new Properties();
        p.put("text.today", "Today");
        p.put("text.month", "Month");
        p.put("text.year", "Year");
        JDatePanelImpl datePanel = new JDatePanelImpl(this.dateModel, p);
        this.datePicker = new JDatePickerImpl(datePanel, new DateComponentFormatter());
        this.datePicker.setBorder(BorderFactory.createBevelBorder(1));
        JFormattedTextField dateTextField = this.datePicker.getJFormattedTextField();
        dateTextField.setFont(new Font("Monospaced", 1, 20));
        dateTextField.setBackground(Color.WHITE);
        dateTextField.setHorizontalAlignment(0);
    }

    private void createDateModelToday() {
        this.dateModel = new UtilDateModel();
        Calendar calendar = Calendar.getInstance();
        this.dateModel.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
        this.dateModel.setSelected(true);
    }

    public JPanel getPickerPanel() {
        return this.pickerPanel;
    }

    public JDatePickerImpl getDatePicker() {
        return this.datePicker;
    }
}

