/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class SteppedComboBox<T>
extends JComboBox<T> {
    private static final long serialVersionUID = 1L;
    protected int popupWidth;

    public SteppedComboBox(ComboBoxModel<T> aModel) {
        super(aModel);
        this.setUI(new SteppedComboBoxUI());
        this.popupWidth = 0;
    }

    public SteppedComboBox() {
        this.setUI(new SteppedComboBoxUI());
        this.popupWidth = 0;
    }

    public SteppedComboBox(T[] items) {
        super(items);
        this.setUI(new SteppedComboBoxUI());
        this.popupWidth = 0;
    }

    public SteppedComboBox(Vector<T> items) {
        super(items);
        this.setUI(new SteppedComboBoxUI());
        this.popupWidth = 0;
    }

    public void setPopupWidth(int width) {
        this.popupWidth = width;
    }

    public Dimension getPopupSize() {
        Dimension size = this.getSize();
        if (this.popupWidth < 1) {
            this.popupWidth = size.width;
        }
        return new Dimension(this.popupWidth, size.height);
    }

    class SteppedComboBoxUI
    extends MetalComboBoxUI {
        SteppedComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this.comboBox){
                private static final long serialVersionUID = 1L;

                @Override
                public void show() {
                    Dimension popupSize = ((SteppedComboBox)this.comboBox).getPopupSize();
                    popupSize.setSize(popupSize.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                    Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
                    this.scroller.setMaximumSize(popupBounds.getSize());
                    this.scroller.setPreferredSize(popupBounds.getSize());
                    this.scroller.setMinimumSize(popupBounds.getSize());
                    this.list.invalidate();
                    int selectedIndex = this.comboBox.getSelectedIndex();
                    if (selectedIndex == -1) {
                        this.list.clearSelection();
                    } else {
                        this.list.setSelectedIndex(selectedIndex);
                    }
                    this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                    this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
                    this.show(this.comboBox, popupBounds.x, popupBounds.y);
                }
            };
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }
    }
}

